/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Dimension2D;
import java.awt.geom.PathIterator;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.UDrawable;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.USegmentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircledCharacter
implements UDrawable,
TextBlock {
    private final String c;
    private final UFont font;
    private final HtmlColor innerCircle;
    private final HtmlColor circle;
    private final HtmlColor fontColor;
    private final double radius;

    public CircledCharacter(char c, double d, UFont uFont, HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3) {
        this.c = "" + c;
        this.radius = d;
        this.font = uFont;
        this.innerCircle = htmlColor;
        this.circle = htmlColor2;
        this.fontColor = htmlColor3;
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        if (this.circle != null) {
            uGraphic.getParam().setColor(this.circle);
        }
        HtmlColor htmlColor = uGraphic.getParam().getBackcolor();
        uGraphic.getParam().setBackcolor(this.innerCircle);
        uGraphic.draw(d, d2, new UEllipse(this.radius * 2.0, this.radius * 2.0));
        uGraphic.getParam().setColor(this.fontColor);
        uGraphic.centerChar(d + this.radius, d2 + this.radius, this.c.charAt(0), this.font);
        uGraphic.getParam().setBackcolor(htmlColor);
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        return 2.0 * this.radius;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return 2.0 * this.radius;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        this.drawU(uGraphic, 0.0, 0.0);
    }

    private PathIterator getPathIteratorCharacter(FontRenderContext fontRenderContext) {
        TextLayout textLayout = new TextLayout(this.c, this.font.getFont(), fontRenderContext);
        Shape shape = textLayout.getOutline(null);
        return shape.getPathIterator(null);
    }

    public UPath getUPath(FontRenderContext fontRenderContext) {
        UPath uPath = new UPath();
        PathIterator pathIterator = this.getPathIteratorCharacter(fontRenderContext);
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            uPath.add(dArray, USegmentType.getByCode(n));
            pathIterator.next();
        }
        return uPath;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getPreferredWidth(stringBounder), this.getPreferredHeight(stringBounder));
    }

    @Override
    public List<Url> getUrls() {
        return Collections.emptyList();
    }
}

