/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FontStyle {
    PLAIN,
    ITALIC,
    BOLD,
    UNDERLINE,
    STRIKE,
    WAVE,
    BACKCOLOR;


    public UFont mutateFont(UFont uFont) {
        if (this == ITALIC) {
            return uFont.deriveStyle(uFont.getStyle() | 2);
        }
        if (this == BOLD) {
            return uFont.deriveStyle(uFont.getStyle() | 1);
        }
        return uFont;
    }

    public String getActivationPattern() {
        if (this == ITALIC) {
            return "\\<[iI]\\>";
        }
        if (this == BOLD) {
            return "\\<[bB]\\>";
        }
        if (this == UNDERLINE) {
            return "\\<[uU](?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
        }
        if (this == WAVE) {
            return "\\<[wW](?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
        }
        if (this == BACKCOLOR) {
            return "\\<[bB][aA][cC][kK](?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
        }
        if (this == STRIKE) {
            return "\\<(?:s|S|strike|STRIKE|del|DEL)(?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
        }
        return null;
    }

    HtmlColor getExtendedColor(String string) {
        Matcher matcher = Pattern.compile(this.getActivationPattern()).matcher(string);
        if (!matcher.find() || matcher.groupCount() != 1) {
            return null;
        }
        String string2 = matcher.group(1);
        if (HtmlColorUtils.getColorIfValid(string2) != null) {
            return HtmlColorUtils.getColorIfValid(string2);
        }
        return null;
    }

    public String getDeactivationPattern() {
        if (this == ITALIC) {
            return "\\</[iI]\\>";
        }
        if (this == BOLD) {
            return "\\</[bB]\\>";
        }
        if (this == UNDERLINE) {
            return "\\</[uU]\\>";
        }
        if (this == WAVE) {
            return "\\</[wW]\\>";
        }
        if (this == BACKCOLOR) {
            return "\\</[bB][aA][cC][kK]\\>";
        }
        if (this == STRIKE) {
            return "\\</(?:s|S|strike|STRIKE|del|DEL)\\>";
        }
        return null;
    }

    public static FontStyle getStyle(String string) {
        for (FontStyle fontStyle : EnumSet.allOf(FontStyle.class)) {
            if (fontStyle == PLAIN || !string.matches(fontStyle.getActivationPattern()) && !string.matches(fontStyle.getDeactivationPattern())) continue;
            return fontStyle;
        }
        throw new IllegalArgumentException(string);
    }
}

