/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmbededDiagram;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.EmbededSystemLine;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.Line;
import net.sourceforge.plantuml.graphic.SingleLine;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextBlockSimple
implements TextBlock {
    private final List<Line> lines = new ArrayList<Line>();

    protected TextBlockSimple(List<? extends CharSequence> list, FontConfiguration fontConfiguration, HorizontalAlignement horizontalAlignement, SpriteContainer spriteContainer) {
        for (CharSequence charSequence : list) {
            if (charSequence instanceof Stereotype) {
                this.lines.addAll(this.createLinesForStereotype(fontConfiguration, (Stereotype)charSequence, horizontalAlignement, spriteContainer));
                continue;
            }
            if (charSequence instanceof EmbededDiagram) {
                this.lines.add(new EmbededSystemLine((EmbededDiagram)charSequence));
                continue;
            }
            this.lines.add(new SingleLine(((Object)charSequence).toString(), fontConfiguration, horizontalAlignement, spriteContainer));
        }
    }

    @Override
    public List<Url> getUrls() {
        ArrayList<Url> arrayList = new ArrayList<Url>();
        for (Line line : this.lines) {
            arrayList.addAll(line.getUrls());
        }
        return Collections.unmodifiableList(arrayList);
    }

    private List<SingleLine> createLinesForStereotype(FontConfiguration fontConfiguration, Stereotype stereotype, HorizontalAlignement horizontalAlignement, SpriteContainer spriteContainer) {
        assert (stereotype.getLabel() != null);
        ArrayList<SingleLine> arrayList = new ArrayList<SingleLine>();
        for (String string : stereotype.getLabels()) {
            arrayList.add(new SingleLine(string, fontConfiguration.add(FontStyle.ITALIC), horizontalAlignement, spriteContainer));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getTextDimension(stringBounder);
    }

    protected final Dimension2D getTextDimension(StringBounder stringBounder) {
        double d = 0.0;
        double d2 = 0.0;
        for (Line line : this.lines) {
            Dimension2D dimension2D = line.calculateDimension(stringBounder);
            d2 += dimension2D.getHeight();
            d = Math.max(d, dimension2D.getWidth());
        }
        return new Dimension2DDouble(d, d2);
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        Dimension2D dimension2D = this.getTextDimension(uGraphic.getStringBounder());
        for (Line line : this.lines) {
            HorizontalAlignement horizontalAlignement = line.getHorizontalAlignement();
            double d3 = 0.0;
            if (horizontalAlignement == HorizontalAlignement.CENTER) {
                double d4 = dimension2D.getWidth() - line.calculateDimension(uGraphic.getStringBounder()).getWidth();
                d3 = d4 / 2.0;
            }
            line.drawU(uGraphic, d + d3, d2);
            d2 += line.calculateDimension(uGraphic.getStringBounder()).getHeight();
        }
    }
}

