/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.ImgValign;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TileImage
implements TextBlock {
    private final BufferedImage image;
    private final int vspace;

    public TileImage(BufferedImage bufferedImage, ImgValign imgValign, int n) {
        this.image = bufferedImage;
        this.vspace = n;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.image.getWidth(), this.image.getHeight() + 2 * this.vspace);
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        uGraphic.draw(d, d2 + (double)this.vspace, new UImage(this.image));
    }

    @Override
    public List<Url> getUrls() {
        return Collections.emptyList();
    }
}

