/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.jdbc.PBlob;
import net.sourceforge.plantuml.jdbc.PInteger;
import net.sourceforge.plantuml.jdbc.PLine;
import net.sourceforge.plantuml.jdbc.PName;
import net.sourceforge.plantuml.jdbc.PPreparedStatement;
import net.sourceforge.plantuml.jdbc.PResultSet;
import net.sourceforge.plantuml.jdbc.PResultSetMetaData;
import net.sourceforge.plantuml.jdbc.PString;
import net.sourceforge.plantuml.jdbc.PTable;
import net.sourceforge.plantuml.jdbc.PType;
import net.sourceforge.plantuml.jdbc.SqlTable;
import net.sourceforge.plantuml.jdbc.TraceObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramTable
extends TraceObject
implements SqlTable {
    private String code = "@startuml\nBob->Alice\n@enduml";
    private String description;
    private byte[] png;

    public DiagramTable() {
        this.updatePng();
    }

    @Override
    public int executeUpdate(Map<Integer, Object> map) {
        this.code = map.get(1).toString();
        this.updatePng();
        return 1;
    }

    private void updatePng() {
        SourceStringReader sourceStringReader = new SourceStringReader(this.code);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.description = sourceStringReader.generateImage(byteArrayOutputStream);
            byteArrayOutputStream.close();
            this.png = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.description = iOException.toString();
        }
    }

    @Override
    public PTable getColumns(PResultSetMetaData pResultSetMetaData) {
        PTable pTable = new PTable(pResultSetMetaData);
        pTable.addLine(new PLine(new PString("Catalog2"), new PString("Schema1"), new PString("DIAGRAM"), new PString("CODE"), new PInteger(PType.VARCHAR.getColumnType()), new PString(PType.VARCHAR.getColumnTypeName()), new PInteger(PType.VARCHAR.getPrecision()), null, null, new PInteger(10), new PInteger(2), new PString("UML starting with @startuml"), null, new PInteger(0), new PInteger(0), new PInteger(PType.VARCHAR.getPrecision()), new PInteger(1), new PString(""), null, null, null, null, new PString("NO")));
        pTable.addLine(new PLine(new PString("Catalog2"), new PString("Schema1"), new PString("DIAGRAM"), new PString("DESCRIPTION"), new PInteger(PType.VARCHAR.getColumnType()), new PString(PType.VARCHAR.getColumnTypeName()), new PInteger(PType.VARCHAR.getPrecision()), null, null, new PInteger(10), new PInteger(2), new PString("Description of the diagram"), null, new PInteger(0), new PInteger(0), new PInteger(PType.VARCHAR.getPrecision()), new PInteger(2), new PString(""), null, null, null, null, new PString("NO")));
        pTable.addLine(new PLine(new PString("Catalog2"), new PString("Schema1"), new PString("DIAGRAM"), new PString("PNG"), new PInteger(PType.BLOB.getColumnType()), new PString(PType.BLOB.getColumnTypeName()), new PInteger(PType.BLOB.getPrecision()), null, null, new PInteger(10), new PInteger(2), new PString("PNG image"), null, new PInteger(0), new PInteger(0), new PInteger(PType.VARCHAR.getPrecision()), new PInteger(3), new PString(""), null, null, null, null, new PString("NO")));
        return pTable;
    }

    @Override
    public PTable asBestRowIdentifier(PResultSetMetaData pResultSetMetaData) {
        PTable pTable = new PTable(pResultSetMetaData);
        pTable.addLine(new PLine(new PInteger(2), new PString("CODE"), new PInteger(PType.VARCHAR.getColumnType()), new PString(PType.VARCHAR.getColumnTypeName()), new PInteger(PType.VARCHAR.getPrecision()), new PInteger(0), null, new PInteger(1)));
        return pTable;
    }

    @Override
    public ResultSet executeQuery(String string) {
        PTable pTable;
        boolean bl = (string = string.toUpperCase()).contains("COUNT(*)");
        if (bl) {
            PResultSetMetaData pResultSetMetaData = new PResultSetMetaData(new PName("COUNT", PType.INTEGER));
            pTable = new PTable(pResultSetMetaData);
            pTable.addLine(new PLine(new PInteger(0)));
        } else {
            PResultSetMetaData pResultSetMetaData = new PResultSetMetaData(new PName("CODE", PType.VARCHAR), new PName("DESCRIPTION", PType.VARCHAR), new PName("PNG", PType.BLOB));
            pTable = new PTable(pResultSetMetaData);
            pTable.addLine(new PLine(new PString(this.code), new PString(this.description), new PBlob(this.png)));
        }
        return new PResultSet(pTable);
    }

    @Override
    public PTable getPrimaryKeys(PResultSetMetaData pResultSetMetaData) {
        PTable pTable = new PTable(pResultSetMetaData);
        pTable.addLine(new PLine(new PString("Catalog2"), new PString("Schema1"), new PString("DIAGRAM"), new PString("CODE"), new PInteger(1), new PString("CODE")));
        return pTable;
    }

    @Override
    public PreparedStatement prepareStatement(String string) {
        return new PPreparedStatement(this, string);
    }
}

