/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.png.PngIOMetadata;

public class PngIO {
    private static final String copyleft = "Generated by http://plantuml.sourceforge.net";

    public static void write(RenderedImage renderedImage, File file, int n) throws IOException {
        PngIO.write(renderedImage, file, null, n);
    }

    public static void write(RenderedImage renderedImage, OutputStream outputStream, int n) throws IOException {
        PngIO.write(renderedImage, outputStream, null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(RenderedImage renderedImage, File file, String string, int n) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            PngIO.write(renderedImage, outputStream, string, n);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        Log.debug("File is " + file);
        Log.debug("File size " + file.length());
        if (file.length() == 0L) {
            Log.error("File size is zero: " + file);
            ImageIO.write(renderedImage, "png", file);
        }
    }

    public static void write(RenderedImage renderedImage, OutputStream outputStream, String string, int n) throws IOException {
        if (PngIO.checkPNGMetadata()) {
            PngIOMetadata.writeWithMetadata(renderedImage, outputStream, string, n);
        } else {
            ImageIO.write(renderedImage, "png", outputStream);
        }
    }

    static boolean checkPNGMetadata() {
        try {
            Class<?> clazz = Class.forName("com.sun.imageio.plugins.png.PNGMetadata");
            if (clazz == null) {
                Log.info("Cannot load com.sun.imageio.plugins.png.PNGMetadata");
                return false;
            }
            Log.info("Ok for com.sun.imageio.plugins.png.PNGMetadata");
            return true;
        }
        catch (Exception exception) {
            Log.info("Error loading com.sun.imageio.plugins.png.PNGMetadata " + exception);
            return false;
        }
    }
}

