/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.util.List;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalPosition;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngTitler {
    private final HtmlColor textColor;
    private final List<? extends CharSequence> text;
    private final int fontSize;
    private final String fontFamily;
    private final HorizontalAlignement horizontalAlignement;
    private final VerticalPosition verticalPosition;
    private final ColorMapper colorMapper;

    public PngTitler(ColorMapper colorMapper, HtmlColor htmlColor, List<? extends CharSequence> list, int n, String string, HorizontalAlignement horizontalAlignement, VerticalPosition verticalPosition) {
        this.textColor = htmlColor;
        this.colorMapper = colorMapper;
        this.text = list;
        this.fontSize = n;
        this.fontFamily = string;
        this.horizontalAlignement = horizontalAlignement;
        this.verticalPosition = verticalPosition;
    }

    public BufferedImage processImage(BufferedImage bufferedImage, HtmlColor htmlColor, int n) {
        if (this.text != null && this.text.size() > 0) {
            bufferedImage = PngTitler.addTitle(this.colorMapper, bufferedImage, htmlColor, this.textColor, this.text, this.fontSize, this.fontFamily, this.horizontalAlignement, this.verticalPosition, n);
        }
        return bufferedImage;
    }

    public Dimension2D getTextDimension(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        if (textBlock == null) {
            return null;
        }
        return textBlock.calculateDimension(stringBounder);
    }

    public TextBlock getTextBlock() {
        if (this.text == null || this.text.size() == 0) {
            return null;
        }
        UFont uFont = new UFont(this.fontFamily, 0, this.fontSize);
        return TextBlockUtils.create(this.text, new FontConfiguration(uFont, this.textColor), this.horizontalAlignement, new SpriteContainerEmpty());
    }

    private static BufferedImage addTitle(ColorMapper colorMapper, BufferedImage bufferedImage, HtmlColor htmlColor, HtmlColor htmlColor2, List<? extends CharSequence> list, int n, String string, HorizontalAlignement horizontalAlignement, VerticalPosition verticalPosition, int n2) {
        int n3;
        int n4;
        double d;
        UFont uFont = new UFont(string, 0, n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        TextBlock textBlock = TextBlockUtils.create(list, new FontConfiguration(uFont, htmlColor2), horizontalAlignement, new SpriteContainerEmpty());
        Dimension2D dimension2D = textBlock.calculateDimension(StringBounderUtils.asStringBounder(graphics2D));
        graphics2D.dispose();
        double d2 = Math.max((double)bufferedImage.getWidth(), dimension2D.getWidth());
        double d3 = (double)bufferedImage.getHeight() + dimension2D.getHeight() + (double)n2;
        BufferedImage bufferedImage2 = new BufferedImage((int)d2, (int)d3, 1);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D2.setColor(colorMapper.getMappedColor(htmlColor));
        graphics2D2.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        if (horizontalAlignement == HorizontalAlignement.LEFT) {
            d = 2.0;
        } else if (horizontalAlignement == HorizontalAlignement.RIGHT) {
            d = d2 - dimension2D.getWidth() - 2.0;
        } else if (horizontalAlignement == HorizontalAlignement.CENTER) {
            d = (d2 - dimension2D.getWidth()) / 2.0;
        } else {
            d = 0.0;
            assert (false);
        }
        if (verticalPosition == VerticalPosition.TOP) {
            n4 = 0;
            n3 = (int)dimension2D.getHeight() + n2;
        } else {
            n4 = bufferedImage.getHeight() + n2;
            n3 = 0;
        }
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        textBlock.drawU(new UGraphicG2d(colorMapper, graphics2D2, null, 1.0), d, n4);
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        double d4 = (d2 - (double)bufferedImage.getWidth()) / 2.0;
        graphics2D2.drawImage((Image)bufferedImage, (int)d4, n3, null);
        graphics2D2.dispose();
        return bufferedImage2;
    }

    public double getOffsetX(double d, StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        if (textBlock == null) {
            return 0.0;
        }
        Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
        if (d >= dimension2D.getWidth()) {
            return 0.0;
        }
        return (dimension2D.getWidth() - d) / 2.0;
    }

    public double getOffsetY(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        if (textBlock == null) {
            return 0.0;
        }
        Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
        double d = dimension2D.getHeight();
        return d;
    }
}

