/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.preproc.ReadLine;

public class UncommentReadLine
implements ReadLine {
    private final ReadLine raw;
    private final Pattern start;
    private String headerToRemove;

    public UncommentReadLine(ReadLine readLine) {
        this.raw = readLine;
        this.start = Pattern.compile("(?i)((?:\\W|\\<[^<>]*\\>)*)@start");
    }

    public String readLine() throws IOException {
        String string = this.raw.readLine();
        if (string == null) {
            return null;
        }
        Matcher matcher = this.start.matcher(string);
        if (matcher.find()) {
            this.headerToRemove = matcher.group(1);
        }
        if (this.headerToRemove != null && this.headerToRemove.startsWith(string)) {
            return "";
        }
        if (this.headerToRemove != null && string.startsWith(this.headerToRemove)) {
            return string.substring(this.headerToRemove.length());
        }
        return string;
    }

    public void close() throws IOException {
        this.raw.close();
    }
}

