/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.printskin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.skin.SkinUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PrintSkin
extends AbstractPSystem {
    private static final UFont FONT1 = new UFont("SansSerif", 0, 10);
    private final Skin skin;
    private final List<String> toPrint;
    private UGraphic ug;
    private float xpos = 10.0f;
    private float ypos = 0.0f;
    private float maxYpos = 0.0f;

    @Override
    public void exportDiagram(OutputStream outputStream, StringBuilder stringBuilder, int n, FileFormatOption fileFormatOption) throws IOException {
        BufferedImage bufferedImage = this.createImage();
        PngIO.write((RenderedImage)bufferedImage.getSubimage(0, 0, bufferedImage.getWidth(), (int)this.maxYpos), outputStream, 96);
    }

    private BufferedImage createImage() {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(2000, 830, Color.WHITE);
        BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
        Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
        this.ug = new UGraphicG2d(new ColorMapperIdentity(), graphics2D, null, 1.0);
        for (ComponentType componentType : ComponentType.values()) {
            this.printComponent(componentType);
            this.ypos += 10.0f;
            this.maxYpos = Math.max(this.maxYpos, this.ypos);
            if (!(this.ypos > 620.0f)) continue;
            this.ypos = 0.0f;
            this.xpos += 200.0f;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private void printComponent(ComponentType componentType) {
        this.println(componentType.name());
        Component component = this.skin.createComponent(componentType, ArrowConfiguration.withDirection(ArrowDirection.LEFT_TO_RIGHT_NORMAL), new SkinParam(null), this.toPrint);
        if (component == null) {
            this.println("null");
            return;
        }
        double d = component.getPreferredHeight(this.ug.getStringBounder());
        double d2 = component.getPreferredWidth(this.ug.getStringBounder());
        this.println("height = " + String.format("%4.2f", d));
        this.println("width = " + d2);
        if (d == 0.0) {
            d = 42.0;
        }
        if (d2 == 0.0) {
            d2 = 42.0;
        }
        this.ug.getParam().setColor(HtmlColorUtils.LIGHT_GRAY);
        this.ug.getParam().setBackcolor(HtmlColorUtils.LIGHT_GRAY);
        this.ug.draw(this.xpos - 1.0f, this.ypos - 1.0f, new URectangle(d2 + 2.0, d + 2.0));
        this.ug.translate(this.xpos, this.ypos);
        this.ug.getParam().reset();
        component.drawU(this.ug, new Area(new Dimension2DDouble(d2, d)), new SimpleContext2D(false));
        this.ug.translate(-this.xpos, -this.ypos);
        this.ypos = (float)((double)this.ypos + d);
    }

    private void println(String string) {
        TextBlock textBlock = TextBlockUtils.create(Arrays.asList(string), new FontConfiguration(FONT1, HtmlColorUtils.BLACK), HorizontalAlignement.LEFT, new SpriteContainerEmpty());
        textBlock.drawU(this.ug, this.xpos, this.ypos);
        this.ypos = (float)((double)this.ypos + textBlock.calculateDimension(this.ug.getStringBounder()).getHeight());
    }

    @Override
    public String getDescription() {
        return "Printing of " + this.skin.getClass().getName();
    }

    public PrintSkin(String string, List<String> list) {
        this.skin = SkinUtils.loadSkin(string);
        this.toPrint = list;
    }
}

