/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.DataSourceImpl;
import net.sourceforge.plantuml.salt.Dictionary;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.factory.AbstractElementFactoryComplex;
import net.sourceforge.plantuml.salt.factory.ElementFactoryBorder;
import net.sourceforge.plantuml.salt.factory.ElementFactoryButton;
import net.sourceforge.plantuml.salt.factory.ElementFactoryCheckboxOff;
import net.sourceforge.plantuml.salt.factory.ElementFactoryCheckboxOn;
import net.sourceforge.plantuml.salt.factory.ElementFactoryDroplist;
import net.sourceforge.plantuml.salt.factory.ElementFactoryImage;
import net.sourceforge.plantuml.salt.factory.ElementFactoryLine;
import net.sourceforge.plantuml.salt.factory.ElementFactoryMenu;
import net.sourceforge.plantuml.salt.factory.ElementFactoryPyramid2;
import net.sourceforge.plantuml.salt.factory.ElementFactoryRadioOff;
import net.sourceforge.plantuml.salt.factory.ElementFactoryRadioOn;
import net.sourceforge.plantuml.salt.factory.ElementFactoryRetrieveFromDictonnary;
import net.sourceforge.plantuml.salt.factory.ElementFactoryTab;
import net.sourceforge.plantuml.salt.factory.ElementFactoryText;
import net.sourceforge.plantuml.salt.factory.ElementFactoryTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaltUtils {
    public static Element createElement(List<String> list) {
        DataSourceImpl dataSourceImpl = new DataSourceImpl(list);
        ArrayList<AbstractElementFactoryComplex> arrayList = new ArrayList<AbstractElementFactoryComplex>();
        Dictionary dictionary = new Dictionary();
        arrayList.add(new ElementFactoryPyramid2(dataSourceImpl, dictionary));
        arrayList.add(new ElementFactoryBorder(dataSourceImpl, dictionary));
        for (AbstractElementFactoryComplex abstractElementFactoryComplex : arrayList) {
            SaltUtils.addSimpleFactory(abstractElementFactoryComplex, dataSourceImpl, dictionary);
        }
        for (AbstractElementFactoryComplex abstractElementFactoryComplex : arrayList) {
            for (AbstractElementFactoryComplex abstractElementFactoryComplex2 : arrayList) {
                abstractElementFactoryComplex.addFactory(abstractElementFactoryComplex2);
            }
        }
        for (AbstractElementFactoryComplex abstractElementFactoryComplex : arrayList) {
            if (!abstractElementFactoryComplex.ready()) continue;
            return abstractElementFactoryComplex.create().getElement();
        }
        Log.println("data=" + list);
        throw new IllegalArgumentException();
    }

    private static void addSimpleFactory(AbstractElementFactoryComplex abstractElementFactoryComplex, DataSource dataSource, Dictionary dictionary) {
        abstractElementFactoryComplex.addFactory(new ElementFactoryMenu(dataSource, dictionary));
        abstractElementFactoryComplex.addFactory(new ElementFactoryTab(dataSource, dictionary));
        abstractElementFactoryComplex.addFactory(new ElementFactoryLine(dataSource));
        abstractElementFactoryComplex.addFactory(new ElementFactoryTextField(dataSource, dictionary));
        abstractElementFactoryComplex.addFactory(new ElementFactoryButton(dataSource, dictionary));
        abstractElementFactoryComplex.addFactory(new ElementFactoryDroplist(dataSource, dictionary));
        abstractElementFactoryComplex.addFactory(new ElementFactoryRadioOn(dataSource, dictionary));
        abstractElementFactoryComplex.addFactory(new ElementFactoryRadioOff(dataSource, dictionary));
        abstractElementFactoryComplex.addFactory(new ElementFactoryCheckboxOn(dataSource, dictionary));
        abstractElementFactoryComplex.addFactory(new ElementFactoryCheckboxOff(dataSource, dictionary));
        abstractElementFactoryComplex.addFactory(new ElementFactoryImage(dataSource, dictionary));
        abstractElementFactoryComplex.addFactory(new ElementFactoryRetrieveFromDictonnary(dataSource, dictionary));
        abstractElementFactoryComplex.addFactory(new ElementFactoryText(dataSource, dictionary));
    }
}

