/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

abstract class AbstractElementText
implements Element {
    private final TextBlock block;
    private final FontConfiguration config;
    private final int charLength;

    public AbstractElementText(String string, UFont uFont, boolean bl, SpriteContainer spriteContainer) {
        this.config = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        if (bl) {
            this.charLength = string.length();
            string = string.trim();
        } else {
            this.charLength = 0;
        }
        this.block = TextBlockUtils.create(Arrays.asList(string), this.config, HorizontalAlignement.LEFT, spriteContainer);
    }

    protected void drawText(UGraphic uGraphic, double d, double d2) {
        this.block.drawU(uGraphic, d, d2);
    }

    protected Dimension2D getPureTextDimension(StringBounder stringBounder) {
        return this.block.calculateDimension(stringBounder);
    }

    protected Dimension2D getTextDimensionAt(StringBounder stringBounder, double d) {
        Dimension2D dimension2D = this.block.calculateDimension(stringBounder);
        if (this.charLength == 0) {
            return dimension2D;
        }
        double d2 = this.getSingleSpace(stringBounder);
        return new Dimension2DDouble(Math.max(dimension2D.getWidth(), (double)this.charLength * d2), dimension2D.getHeight());
    }

    private double getSingleSpace(StringBounder stringBounder) {
        return 8.0;
    }
}

