/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementText;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;

public class ElementTabBar
implements Element {
    private final Collection<Element> tabs = new ArrayList<Element>();
    private final UFont font;
    private final SpriteContainer spriteContainer;
    private final double margin1 = 2.0;
    private final double margin2 = 3.0;
    private final double margin3 = 10.0;
    private boolean vertical = false;

    public ElementTabBar(UFont uFont, SpriteContainer spriteContainer) {
        this.font = uFont;
        this.spriteContainer = spriteContainer;
    }

    public void addTab(String string) {
        ElementText elementText = new ElementText(Arrays.asList(string), this.font, this.spriteContainer);
        this.tabs.add(elementText);
    }

    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        if (this.vertical) {
            return this.getPreferredDimensionVertical(stringBounder, d, d2);
        }
        return this.getPreferredDimensionHorizontal(stringBounder, d, d2);
    }

    private Dimension2D getPreferredDimensionHorizontal(StringBounder stringBounder, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        for (Element element : this.tabs) {
            Dimension2D dimension2D = element.getPreferredDimension(stringBounder, d, d2);
            d3 += dimension2D.getWidth() + 2.0 + 3.0 + 10.0;
            d4 = Math.max(d4, dimension2D.getHeight());
        }
        return new Dimension2DDouble(d3, d4);
    }

    public void drawU(UGraphic uGraphic, double d, double d2, int n, Dimension2D dimension2D) {
        if (n != 0) {
            return;
        }
        if (this.vertical) {
            this.drawUVertical(uGraphic, d, d2, n, dimension2D);
        } else {
            this.drawUHorizontal(uGraphic, d, d2, n, dimension2D);
        }
    }

    private void drawUHorizontal(UGraphic uGraphic, double d, double d2, int n, Dimension2D dimension2D) {
        double d3 = d;
        for (Element element : this.tabs) {
            element.drawU(uGraphic, d3 + 2.0, d2, n, dimension2D);
            Dimension2D dimension2D2 = element.getPreferredDimension(uGraphic.getStringBounder(), d3, d2);
            double d4 = dimension2D2.getWidth();
            uGraphic.draw(d3, d2, new ULine(0.0, dimension2D2.getHeight()));
            uGraphic.draw(d3, d2, new ULine(d4 + 2.0 + 3.0, 0.0));
            uGraphic.draw(d3 + d4 + 2.0 + 3.0, d2, new ULine(0.0, dimension2D2.getHeight()));
            uGraphic.draw(d3 + d4 + 2.0 + 3.0, d2 + dimension2D2.getHeight(), new ULine(10.0, 0.0));
            d3 += d4 + 2.0 + 3.0 + 10.0;
        }
    }

    private Dimension2D getPreferredDimensionVertical(StringBounder stringBounder, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        for (Element element : this.tabs) {
            Dimension2D dimension2D = element.getPreferredDimension(stringBounder, d, d2);
            d4 += dimension2D.getHeight() + 2.0 + 3.0 + 10.0;
            d3 = Math.max(d3, dimension2D.getWidth());
        }
        return new Dimension2DDouble(d3, d4);
    }

    private void drawUVertical(UGraphic uGraphic, double d, double d2, int n, Dimension2D dimension2D) {
        Dimension2D dimension2D2 = this.getPreferredDimension(uGraphic.getStringBounder(), d, d2);
        double d3 = d;
        for (Element element : this.tabs) {
            element.drawU(uGraphic, d, d3 + 2.0, n, dimension2D);
            Dimension2D dimension2D3 = element.getPreferredDimension(uGraphic.getStringBounder(), d, d3);
            double d4 = dimension2D3.getHeight();
            uGraphic.draw(d, d3, new ULine(dimension2D2.getWidth(), 0.0));
            uGraphic.draw(d, d3, new ULine(0.0, d4 + 2.0 + 3.0));
            uGraphic.draw(d, d3 + d4 + 2.0 + 3.0, new ULine(dimension2D2.getWidth(), 0.0));
            uGraphic.draw(d + dimension2D2.getWidth(), d3 + d4 + 2.0 + 3.0, new ULine(0.0, 10.0));
            d3 += d4 + 2.0 + 3.0 + 10.0;
        }
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean bl) {
        this.vertical = bl;
    }
}

