/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementText
implements Element {
    private final TextBlock block;
    private final boolean show;
    private final String text;

    public ElementText(List<String> list, UFont uFont, SpriteContainer spriteContainer) {
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        this.block = TextBlockUtils.create(list, fontConfiguration, HorizontalAlignement.LEFT, spriteContainer);
        this.show = !list.get(0).equals(".");
        this.text = list.get(0);
    }

    @Override
    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        return this.block.calculateDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2, int n, Dimension2D dimension2D) {
        if (n != 0) {
            return;
        }
        if (this.show) {
            this.block.drawU(uGraphic, d, d2);
        }
    }

    public final String getText() {
        return this.text;
    }
}

