/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.factory;

import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.Dictionary;
import net.sourceforge.plantuml.salt.Positionner;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementPyramid;
import net.sourceforge.plantuml.salt.element.TableStrategy;
import net.sourceforge.plantuml.salt.factory.AbstractElementFactoryComplex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementFactoryPyramid
extends AbstractElementFactoryComplex {
    public ElementFactoryPyramid(DataSource dataSource, Dictionary dictionary) {
        super(dataSource, dictionary);
    }

    @Override
    public Terminated<Element> create() {
        if (!this.ready()) {
            throw new IllegalStateException();
        }
        String string = (String)((Terminated)this.getDataSource().next()).getElement();
        assert (string.startsWith("{"));
        TableStrategy tableStrategy = TableStrategy.DRAW_NONE;
        if (string.length() == 2) {
            tableStrategy = TableStrategy.fromChar(string.charAt(1));
        }
        Positionner positionner = new Positionner();
        while (!this.getDataSource().peek(0).getElement().equals("}")) {
            positionner.add(this.getNextElement());
        }
        Terminated terminated = (Terminated)this.getDataSource().next();
        return new Terminated<Element>(new ElementPyramid(positionner, tableStrategy), terminated.getTerminator());
    }

    @Override
    public boolean ready() {
        String string = this.getDataSource().peek(0).getElement();
        if (string.equals("{") || string.equals("{+") || string.equals("{#") || string.equals("{!") || string.equals("{-")) {
            String string2 = this.getDataSource().peek(1).getElement();
            return !string2.matches("[NSEW]=");
        }
        return false;
    }
}

