/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramInfo;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Delay;
import net.sourceforge.plantuml.sequencediagram.Divider;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Grouping;
import net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import net.sourceforge.plantuml.sequencediagram.GroupingStart;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.sequencediagram.Reference;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramFileMaker;
import net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramTxtMaker;
import net.sourceforge.plantuml.skin.ProtectedSkin;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.skin.SkinUtils;
import net.sourceforge.plantuml.skin.rose.Rose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceDiagram
extends UmlDiagram {
    private final Map<String, Participant> participants = new LinkedHashMap<String, Participant>();
    private final List<Event> events = new ArrayList<Event>();
    private final Map<Participant, ParticipantEnglober> participantEnglobers2 = new HashMap<Participant, ParticipantEnglober>();
    private Skin skin = new ProtectedSkin(new Rose());
    private AbstractMessage lastMessage;
    private boolean ignoreNewpage = false;
    private int autonewpage = -1;
    private Delay lastDelay;
    private final Stack<Message> activationState = new Stack();
    private LifeEvent pendingCreate = null;
    private final List<GroupingStart> openGroupings = new ArrayList<GroupingStart>();
    private Integer messageNumber = null;
    private int incrementMessageNumber;
    private DecimalFormat decimalFormat;
    private boolean showFootbox = true;
    private ParticipantEnglober participantEnglober;
    private boolean autoactivate;

    @Deprecated
    public Participant getOrCreateParticipant(String string) {
        return this.getOrCreateParticipant(string, StringUtils.getWithNewlines(string));
    }

    public Participant getOrCreateParticipant(String string, List<String> list) {
        Participant participant = this.participants.get(string);
        if (participant == null) {
            participant = new Participant(ParticipantType.PARTICIPANT, string, list);
            this.participants.put(string, participant);
            this.participantEnglobers2.put(participant, this.participantEnglober);
        }
        return participant;
    }

    public AbstractMessage getLastMessage() {
        return this.lastMessage;
    }

    public Participant createNewParticipant(ParticipantType participantType, String string, List<String> list) {
        if (this.participants.containsKey(string)) {
            throw new IllegalArgumentException();
        }
        if (list == null) {
            list = StringUtils.getWithNewlines(string);
        }
        Participant participant = new Participant(participantType, string, list);
        this.participants.put(string, participant);
        this.participantEnglobers2.put(participant, this.participantEnglober);
        return participant;
    }

    public Map<String, Participant> participants() {
        return Collections.unmodifiableMap(this.participants);
    }

    public String addMessage(AbstractMessage abstractMessage) {
        this.lastMessage = abstractMessage;
        this.lastDelay = null;
        this.events.add(abstractMessage);
        if (this.pendingCreate != null) {
            if (!abstractMessage.compatibleForCreate(this.pendingCreate.getParticipant())) {
                return "After create command, you have to send a message to \"" + this.pendingCreate.getParticipant() + "\"";
            }
            abstractMessage.addLifeEvent(this.pendingCreate);
            this.pendingCreate = null;
        }
        return null;
    }

    public void addNote(Note note) {
        this.events.add(note);
    }

    public void newpage(List<String> list) {
        if (this.ignoreNewpage) {
            return;
        }
        this.events.add(new Newpage(list));
    }

    public void ignoreNewpage() {
        this.ignoreNewpage = true;
    }

    public final int getAutonewpage() {
        return this.autonewpage;
    }

    public void setAutonewpage(int n) {
        this.autonewpage = n;
    }

    public void divider(List<String> list) {
        this.events.add(new Divider(list));
    }

    public void delay(List<String> list) {
        Delay delay = new Delay(list);
        this.events.add(delay);
        this.lastDelay = delay;
    }

    public List<Event> events() {
        return Collections.unmodifiableList(this.events);
    }

    private FileMaker getSequenceDiagramPngMaker(FileFormatOption fileFormatOption, List<BufferedImage> list) {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.ATXT || fileFormat == FileFormat.UTXT) {
            return new SequenceDiagramTxtMaker(this, fileFormat);
        }
        return new SequenceDiagramFileMaker(this, this.skin, fileFormatOption, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<File> exportDiagrams(File file, FileFormatOption fileFormatOption) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = this.getNbImages();
        for (int i = 0; i < n; ++i) {
            File file2 = SequenceDiagramFileMaker.computeFilename(file, i, fileFormatOption.getFileFormat());
            Log.info("Creating file: " + file2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            StringBuilder stringBuilder = new StringBuilder();
            try {
                this.exportDiagram(bufferedOutputStream, stringBuilder, i, fileFormatOption);
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
            }
            if (this.hasUrl() && stringBuilder.length() > 0) {
                this.exportCmap(file, stringBuilder);
            }
            Log.info("File size : " + file2.length());
            arrayList.add(file2);
        }
        return arrayList;
    }

    @Override
    protected UmlDiagramInfo exportDiagramInternal(OutputStream outputStream, StringBuilder stringBuilder, int n, FileFormatOption fileFormatOption, List<BufferedImage> list) throws IOException {
        FileMaker fileMaker = this.getSequenceDiagramPngMaker(fileFormatOption, list);
        UmlDiagramInfo umlDiagramInfo = fileMaker.createOne2(outputStream, n);
        if (stringBuilder != null && this.hasUrl() && fileFormatOption.getFileFormat() == FileFormat.PNG) {
            fileMaker.appendCmap(stringBuilder);
        }
        return umlDiagramInfo;
    }

    public Message getActivatingMessage() {
        if (this.activationState.empty()) {
            return null;
        }
        return this.activationState.peek();
    }

    public String activate(Participant participant, LifeEventType lifeEventType, HtmlColor htmlColor) {
        if (this.lastDelay != null) {
            return "You cannot Activate/Deactivate just after a ...";
        }
        if (lifeEventType == LifeEventType.CREATE) {
            this.pendingCreate = new LifeEvent(participant, lifeEventType, htmlColor);
            return null;
        }
        if (this.lastMessage == null) {
            if (lifeEventType == LifeEventType.ACTIVATE) {
                participant.incInitialLife(htmlColor);
                return null;
            }
            return "Only activate command can occur before message are send";
        }
        if (lifeEventType == LifeEventType.ACTIVATE && this.lastMessage instanceof Message) {
            this.activationState.push((Message)this.lastMessage);
        } else if (lifeEventType == LifeEventType.DEACTIVATE && !this.activationState.empty()) {
            this.activationState.pop();
        }
        boolean bl = this.lastMessage.addLifeEvent(new LifeEvent(participant, lifeEventType, htmlColor));
        if (bl) {
            return null;
        }
        return "Activate/Deactivate already done on " + participant.getCode();
    }

    public boolean grouping(String string, String string2, GroupingType groupingType, HtmlColor htmlColor, HtmlColor htmlColor2) {
        if (groupingType != GroupingType.START && this.openGroupings.size() == 0) {
            return false;
        }
        GroupingStart groupingStart = this.openGroupings.size() > 0 ? this.openGroupings.get(0) : null;
        Grouping grouping = groupingType == GroupingType.START ? new GroupingStart(string, string2, htmlColor, htmlColor2, groupingStart) : new GroupingLeaf(string, string2, groupingType, htmlColor, htmlColor2, groupingStart);
        this.events.add(grouping);
        if (groupingType == GroupingType.START) {
            this.openGroupings.add(0, (GroupingStart)grouping);
        } else if (groupingType == GroupingType.END) {
            this.openGroupings.remove(0);
        }
        return true;
    }

    @Override
    public String getDescription() {
        return "(" + this.participants.size() + " participants)";
    }

    public boolean changeSkin(String string) {
        Skin skin = SkinUtils.loadSkin(string);
        Integer n = new Integer(1);
        if (skin != null && n.equals(skin.getProtocolVersion())) {
            this.skin = new ProtectedSkin(skin);
            return true;
        }
        return false;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public final void goAutonumber(int n, int n2, DecimalFormat decimalFormat) {
        this.messageNumber = n;
        this.incrementMessageNumber = n2;
        this.decimalFormat = decimalFormat;
    }

    public String getNextMessageNumber() {
        if (this.messageNumber == null) {
            return null;
        }
        Integer n = this.messageNumber;
        this.messageNumber = this.messageNumber + this.incrementMessageNumber;
        return this.decimalFormat.format(n);
    }

    public boolean isShowFootbox() {
        String string = this.getSkinParam().getValue("footbox");
        if (string == null) {
            return this.showFootbox;
        }
        return !string.equalsIgnoreCase("hide");
    }

    public void setShowFootbox(boolean bl) {
        this.showFootbox = bl;
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.SEQUENCE;
    }

    public void boxStart(List<String> list, HtmlColor htmlColor) {
        if (this.participantEnglober != null) {
            throw new IllegalStateException();
        }
        this.participantEnglober = new ParticipantEnglober(list, htmlColor);
    }

    public void endBox() {
        if (this.participantEnglober == null) {
            throw new IllegalStateException();
        }
        this.participantEnglober = null;
    }

    public boolean isBoxPending() {
        return this.participantEnglober != null;
    }

    @Override
    public int getNbImages() {
        return this.getSequenceDiagramPngMaker(new FileFormatOption(FileFormat.PNG), null).getNbPages();
    }

    public void removeHiddenParticipants() {
        for (Participant participant : new ArrayList<Participant>(this.participants.values())) {
            if (!this.isAlone(participant)) continue;
            this.remove(participant);
        }
    }

    private void remove(Participant participant) {
        boolean bl = this.participants.values().remove(participant);
        if (!bl) {
            throw new IllegalArgumentException();
        }
        this.participantEnglobers2.remove(participant);
    }

    private boolean isAlone(Participant participant) {
        for (Event event : this.events) {
            if (!event.dealWith(participant)) continue;
            return false;
        }
        return true;
    }

    public void putParticipantInLast(String string) {
        Participant participant = this.participants.get(string);
        if (participant == null) {
            throw new IllegalArgumentException(string);
        }
        this.participants.remove(string);
        this.participants.put(string, participant);
        this.participantEnglobers2.put(participant, this.participantEnglober);
    }

    public ParticipantEnglober getEnglober(Participant participant) {
        return this.participantEnglobers2.get(participant);
    }

    public final void setAutoactivate(boolean bl) {
        this.autoactivate = bl;
    }

    public final boolean isAutoactivate() {
        return this.autoactivate;
    }

    public boolean hasUrl() {
        for (Participant object : this.participants.values()) {
            if (object.getUrl() == null) continue;
            return true;
        }
        for (Event event : this.events) {
            if (event.getUrl() == null) continue;
            return true;
        }
        return false;
    }

    public void addReference(Reference reference) {
        this.events.add(reference);
    }
}

