/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.ArrowAndNoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ConstraintSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.Frontier;
import net.sourceforge.plantuml.sequencediagram.graphic.InGroupablesStack;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.MessageExoArrow;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantRange;
import net.sourceforge.plantuml.sequencediagram.graphic.Step1Abstract;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ComponentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Step1MessageExo
extends Step1Abstract {
    private final MessageExoArrow messageArrow;

    Step1MessageExo(ParticipantRange participantRange, StringBounder stringBounder, MessageExo messageExo, DrawableSet drawableSet, Frontier frontier) {
        super(participantRange, stringBounder, messageExo, drawableSet, frontier);
        this.setConfig(this.getArrowType(messageExo));
        this.messageArrow = new MessageExoArrow(frontier.getFreeY(participantRange), drawableSet.getSkin(), drawableSet.getSkin().createComponent(ComponentType.ARROW, this.getConfig(), drawableSet.getSkinParam(), this.getLabelOfMessage(messageExo)), this.getLivingParticipantBox(), messageExo.getType(), messageExo.getUrl());
        if (messageExo.getNote() != null) {
            SkinParamBackcolored skinParamBackcolored = new SkinParamBackcolored(drawableSet.getSkinParam(), messageExo.getSpecificBackColor());
            this.setNote(drawableSet.getSkin().createComponent(ComponentType.NOTE, null, skinParamBackcolored, messageExo.getNote()));
        }
    }

    @Override
    Frontier prepareMessage(ConstraintSet constraintSet, InGroupablesStack inGroupablesStack) {
        Arrow arrow = this.createArrow();
        double d = arrow.getArrowYStartLevel(this.getStringBounder());
        double d2 = arrow.getArrowYEndLevel(this.getStringBounder());
        for (LifeEvent lifeEvent : this.getMessage().getLiveEvents()) {
            this.beforeMessage(lifeEvent, d);
        }
        double d3 = arrow.getArrowOnlyWidth(this.getStringBounder());
        this.incFreeY(arrow.getPreferredHeight(this.getStringBounder()));
        double d4 = 0.0;
        if (this.getMessage().isActivateAndDeactive()) {
            d4 = 30.0;
            this.incFreeY(d4);
        }
        this.getDrawingSet().addEvent(this.getMessage(), arrow);
        LivingParticipantBox livingParticipantBox = this.getLivingParticipantBox();
        if (this.messageArrow.getType().isRightBorder()) {
            constraintSet.getConstraint(livingParticipantBox.getParticipantBox(), constraintSet.getLastborder()).ensureValue(d3);
        } else {
            constraintSet.getConstraint(constraintSet.getFirstBorder(), livingParticipantBox.getParticipantBox()).ensureValue(d3);
        }
        for (LifeEvent lifeEvent : this.getMessage().getLiveEvents()) {
            this.afterMessage(this.getStringBounder(), lifeEvent, d2 + d4);
        }
        assert (arrow instanceof InGroupable);
        if (arrow instanceof InGroupable) {
            inGroupablesStack.addElement(arrow);
            inGroupablesStack.addElement(livingParticipantBox);
        }
        return this.getFreeY();
    }

    private LivingParticipantBox getLivingParticipantBox() {
        return this.getDrawingSet().getLivingParticipantBox(((MessageExo)this.getMessage()).getParticipant());
    }

    private List<? extends CharSequence> getLabelOfMessage(MessageExo messageExo) {
        if (messageExo.getMessageNumber() == null) {
            return messageExo.getLabel();
        }
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        arrayList.add(new MessageNumber(messageExo.getMessageNumber()));
        arrayList.addAll(messageExo.getLabel());
        return arrayList;
    }

    private Arrow createArrow() {
        if (this.getMessage().getNote() == null) {
            return this.messageArrow;
        }
        NoteBox noteBox = this.createNoteBox(this.getStringBounder(), this.messageArrow, this.getNote(), this.getMessage().getNotePosition(), this.getMessage().getUrlNote());
        return new ArrowAndNoteBox(this.getStringBounder(), this.messageArrow, noteBox);
    }

    private ArrowConfiguration getArrowType(MessageExo messageExo) {
        ArrowConfiguration arrowConfiguration = null;
        MessageExoType messageExoType = messageExo.getType();
        arrowConfiguration = messageExoType.getDirection() == 1 ? ArrowConfiguration.withDirection(ArrowDirection.LEFT_TO_RIGHT_NORMAL) : ArrowConfiguration.withDirection(ArrowDirection.RIGHT_TO_LEFT_REVERSE);
        if (messageExo.getArrowConfiguration().isDotted()) {
            arrowConfiguration = arrowConfiguration.withDotted();
        }
        if (messageExo.getArrowConfiguration().getHead() == ArrowHead.ASYNC) {
            arrowConfiguration = arrowConfiguration.withHead(ArrowHead.ASYNC);
        }
        arrowConfiguration = arrowConfiguration.withPart(messageExo.getArrowConfiguration().getPart());
        return arrowConfiguration;
    }
}

