/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram;

import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;

public class StateDiagram
extends AbstractEntityDiagram {
    private boolean hideEmptyDescription = false;

    public IEntity getOrCreateClass(String string) {
        if (string.startsWith("[*]")) {
            throw new IllegalArgumentException();
        }
        if (this.isGroup(string)) {
            return this.getGroup(string);
        }
        IEntity iEntity = this.getOrCreateEntity(string, EntityType.STATE);
        return iEntity;
    }

    public IEntity getStart() {
        IEntityMutable iEntityMutable = this.getCurrentGroup();
        if (iEntityMutable == null) {
            return this.getOrCreateEntity("*start", EntityType.CIRCLE_START);
        }
        return this.getOrCreateEntity("*start*" + iEntityMutable.zgetGroupCode(), EntityType.CIRCLE_START);
    }

    public IEntity getEnd() {
        IEntityMutable iEntityMutable = this.getCurrentGroup();
        if (iEntityMutable == null) {
            return this.getOrCreateEntity("*end", EntityType.CIRCLE_END);
        }
        return this.getOrCreateEntity("*end*" + iEntityMutable.zgetGroupCode(), EntityType.CIRCLE_END);
    }

    public IEntity getHistorical() {
        IEntityMutable iEntityMutable = this.getCurrentGroup();
        if (iEntityMutable == null) {
            return this.getOrCreateEntity("*historical", EntityType.PSEUDO_STATE);
        }
        return this.getOrCreateEntity("*historical*" + iEntityMutable.zgetGroupCode(), EntityType.PSEUDO_STATE);
    }

    public IEntity getHistorical(String string) {
        IEntityMutable iEntityMutable = this.getOrCreateGroup(string, string, null, GroupType.STATE, null);
        IEntity iEntity = this.getOrCreateEntity("*historical*" + iEntityMutable.zgetGroupCode(), EntityType.PSEUDO_STATE);
        this.endGroup();
        return iEntity;
    }

    public boolean concurrentState() {
        IEntityMutable iEntityMutable = this.getCurrentGroup();
        if (iEntityMutable != null && iEntityMutable.zgetGroupType() == GroupType.CONCURRENT_STATE) {
            super.endGroup();
        }
        IEntityMutable iEntityMutable2 = this.getOrCreateGroup("CONC" + UniqueSequence.getValue(), "", null, GroupType.CONCURRENT_STATE, this.getCurrentGroup());
        if (iEntityMutable != null && iEntityMutable.zgetGroupType() == GroupType.STATE) {
            iEntityMutable.zmoveEntitiesTo(iEntityMutable2);
            super.endGroup();
            IEntityMutable iEntityMutable3 = this.getOrCreateGroup("CONC" + UniqueSequence.getValue(), "", null, GroupType.CONCURRENT_STATE, this.getCurrentGroup());
        }
        return true;
    }

    public void endGroup() {
        IEntityMutable iEntityMutable = this.getCurrentGroup();
        if (iEntityMutable != null && iEntityMutable.zgetGroupType() == GroupType.CONCURRENT_STATE) {
            super.endGroup();
        }
        super.endGroup();
    }

    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.STATE;
    }

    public final void setHideEmptyDescription(boolean bl) {
        this.hideEmptyDescription = bl;
    }

    public final boolean isHideEmptyDescription() {
        return this.hideEmptyDescription;
    }
}

