/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.Shape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bibliotekon {
    private final List<Cluster> allCluster = new ArrayList<Cluster>();
    private final Map<IEntity, Shape> shapeMap = new LinkedHashMap<IEntity, Shape>();
    private final List<Line> lines0 = new ArrayList<Line>();
    private final List<Line> lines1 = new ArrayList<Line>();
    private final List<Line> allLines = new ArrayList<Line>();

    public void putShape(IEntity iEntity, Shape shape) {
        this.shapeMap.put(iEntity, shape);
    }

    public Cluster getCluster(IEntity iEntity) {
        for (Cluster cluster : this.allCluster) {
            if (cluster.getGroup() != iEntity) continue;
            return cluster;
        }
        throw new IllegalArgumentException();
    }

    public void addLine(Line line) {
        this.allLines.add(line);
        if (Bibliotekon.first(line)) {
            this.lines0.add(line);
        } else {
            this.lines1.add(line);
        }
    }

    private static boolean first(Line line) {
        int n = line.getLength();
        return n == 1;
    }

    public void addCluster(Cluster cluster) {
        this.allCluster.add(cluster);
    }

    public Shape getShape(IEntity iEntity) {
        return this.shapeMap.get(iEntity);
    }

    public String getShapeUid(IEntity iEntity) {
        Shape shape = this.getShape(iEntity);
        if (shape != null) {
            String string = shape.getUid();
            if (shape.isShielded()) {
                string = string + ":h";
            }
            return string;
        }
        assert (shape == null);
        if (((IEntityMutable)iEntity).isGroup()) {
            for (IEntity iEntity2 : this.shapeMap.keySet()) {
                if (!((Group)((Object)iEntity)).zgetGroupCode().equals(iEntity2.getCode())) continue;
                return this.getShape(iEntity2).getUid();
            }
            return "za" + ((Group)((Object)iEntity)).zgetUid2();
        }
        throw new IllegalStateException();
    }

    public String getWarningOrError(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<IEntity, Shape> entry : this.shapeMap.entrySet()) {
            Shape shape = entry.getValue();
            double d = shape.getMinX() + shape.getWidth();
            if (!(d > (double)n)) continue;
            IEntity iEntity = entry.getKey();
            stringBuilder.append(iEntity.getCode() + " is overpassing the width limit.");
            stringBuilder.append("\n");
        }
        return stringBuilder.length() == 0 ? "" : stringBuilder.toString();
    }

    public List<Line> allLines() {
        return Collections.unmodifiableList(this.allLines);
    }

    public List<Line> lines0() {
        return Collections.unmodifiableList(this.lines0);
    }

    public List<Line> lines1() {
        return Collections.unmodifiableList(this.lines1);
    }

    public List<Cluster> allCluster() {
        return Collections.unmodifiableList(this.allCluster);
    }

    public Collection<Shape> allShapes() {
        return Collections.unmodifiableCollection(this.shapeMap.values());
    }
}

