/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageActivity
extends AbstractEntityImage {
    public static final int CORNER = 25;
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final List<Url> url;

    public EntityImageActivity(IEntity iEntity, ISkinParam iSkinParam) {
        super(iEntity, iSkinParam);
        Stereotype stereotype = iEntity.getStereotype();
        this.desc = TextBlockUtils.create(iEntity.getDisplay2(), new FontConfiguration(this.getFont(FontParam.ACTIVITY, stereotype), this.getFontColor(FontParam.ACTIVITY, stereotype)), HorizontalAlignement.CENTER, iSkinParam);
        this.url = iEntity.getUrls();
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.desc.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dimension2D, 20.0);
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.getDimension(stringBounder);
        double d3 = dimension2D.getWidth();
        double d4 = dimension2D.getHeight();
        URectangle uRectangle = new URectangle(d3, d4, 25.0, 25.0);
        if (this.getSkinParam().shadowing()) {
            uRectangle.setDeltaShadow(4.0);
        }
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.getParam().setColor(this.getColor(ColorParam.activityBorder, this.getStereo()));
        HtmlColor htmlColor = this.getEntity().getSpecificBackColor();
        if (htmlColor == null) {
            htmlColor = this.getColor(ColorParam.activityBackground, this.getStereo());
        }
        uGraphic.getParam().setBackcolor(htmlColor);
        uGraphic.draw(d, d2, uRectangle);
        uGraphic.getParam().setStroke(new UStroke());
        double d5 = d + 10.0;
        double d6 = d2 + 10.0;
        this.desc.drawU(uGraphic, d5, d6);
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

