/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageAssociation
extends AbstractEntityImage {
    private static final int SIZE = 12;

    public EntityImageAssociation(IEntity iEntity, ISkinParam iSkinParam) {
        super(iEntity, iSkinParam);
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(24.0, 24.0);
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        UPolygon uPolygon = new UPolygon();
        if (this.getSkinParam().shadowing()) {
            uPolygon.setDeltaShadow(5.0);
        }
        uPolygon.addPoint(12.0, 0.0);
        uPolygon.addPoint(24.0, 12.0);
        uPolygon.addPoint(12.0, 24.0);
        uPolygon.addPoint(0.0, 12.0);
        uPolygon.addPoint(12.0, 0.0);
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.getParam().setColor(this.getColor(ColorParam.classBorder, this.getStereo()));
        uGraphic.getParam().setBackcolor(this.getColor(ColorParam.classBackground, this.getStereo()));
        uGraphic.draw(d, d2, uPolygon);
        uGraphic.getParam().setStroke(new UStroke());
    }

    public ShapeType getShapeType() {
        return ShapeType.DIAMOND;
    }

    public int getShield() {
        return 0;
    }
}

