/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageState
extends AbstractEntityImage {
    public static final int CORNER = 25;
    private final TextBlock desc;
    private final TextBlock fields;
    private final List<Url> url;
    public static final int MARGIN = 5;
    public static final int MARGIN_LINE = 5;
    private static final int MIN_WIDTH = 50;
    private static final int MIN_HEIGHT = 50;

    public EntityImageState(IEntity iEntity, ISkinParam iSkinParam) {
        super(iEntity, iSkinParam);
        Stereotype stereotype = iEntity.getStereotype();
        this.desc = TextBlockUtils.create(iEntity.getDisplay2(), new FontConfiguration(this.getFont(FontParam.STATE, stereotype), this.getFontColor(FontParam.STATE, stereotype)), HorizontalAlignement.CENTER, iSkinParam);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Member member : iEntity.getFieldsToDisplay()) {
            arrayList.addAll(StringUtils.getWithNewlines(member.getDisplay(true)));
        }
        this.url = iEntity.getUrls();
        this.fields = TextBlockUtils.create(arrayList, new FontConfiguration(this.getFont(FontParam.STATE_ATTRIBUTE, stereotype), this.getFontColor(FontParam.STATE_ATTRIBUTE, stereotype)), HorizontalAlignement.LEFT, iSkinParam);
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = Dimension2DDouble.mergeTB(this.desc.calculateDimension(stringBounder), this.fields.calculateDimension(stringBounder));
        Dimension2D dimension2D2 = Dimension2DDouble.delta(dimension2D, 20.0);
        return Dimension2DDouble.atLeast(dimension2D2, 50.0, 50.0);
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.getDimension(stringBounder);
        Dimension2D dimension2D2 = this.desc.calculateDimension(stringBounder);
        double d3 = dimension2D.getWidth();
        double d4 = dimension2D.getHeight();
        URectangle uRectangle = new URectangle(d3, d4, 25.0, 25.0);
        if (this.getSkinParam().shadowing()) {
            uRectangle.setDeltaShadow(4.0);
        }
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.getParam().setColor(this.getColor(ColorParam.stateBorder, this.getStereo()));
        HtmlColor htmlColor = this.getEntity().getSpecificBackColor();
        if (htmlColor == null) {
            htmlColor = this.getColor(ColorParam.stateBackground, this.getStereo());
        }
        uGraphic.getParam().setBackcolor(htmlColor);
        uGraphic.draw(d, d2, uRectangle);
        double d5 = d2 + 5.0 + dimension2D2.getHeight() + 5.0;
        uGraphic.draw(d, d5, new ULine(d3, 0.0));
        uGraphic.getParam().setStroke(new UStroke());
        double d6 = (d3 - dimension2D2.getWidth()) / 2.0;
        double d7 = d2 + 5.0;
        this.desc.drawU(uGraphic, d + d6, d7);
        double d8 = d + 5.0;
        double d9 = d5 + 5.0;
        this.fields.drawU(uGraphic, d8, d9);
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

