/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageUseCase
extends AbstractEntityImage {
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final TextBlock stereo;
    private final List<Url> url;

    public EntityImageUseCase(IEntity iEntity, ISkinParam iSkinParam) {
        super(iEntity, iSkinParam);
        Stereotype stereotype = iEntity.getStereotype();
        this.desc = TextBlockUtils.create(iEntity.getDisplay2(), new FontConfiguration(this.getFont(FontParam.USECASE, stereotype), this.getFontColor(FontParam.USECASE, stereotype)), HorizontalAlignement.CENTER, iSkinParam);
        this.stereo = stereotype == null || stereotype.getLabel() == null ? null : TextBlockUtils.create(StringUtils.getWithNewlines(stereotype.getLabel()), new FontConfiguration(this.getFont(FontParam.USECASE_ACTOR_STEREOTYPE, stereotype), this.getFontColor(FontParam.USECASE_ACTOR_STEREOTYPE, null)), HorizontalAlignement.CENTER, iSkinParam);
        this.url = iEntity.getUrls();
    }

    private Dimension2D getStereoDimension(StringBounder stringBounder) {
        if (this.stereo == null) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        return this.stereo.calculateDimension(stringBounder);
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = Dimension2DDouble.mergeTB(this.desc.calculateDimension(stringBounder), this.getStereoDimension(stringBounder));
        return Dimension2DDouble.delta(dimension2D, 20.0);
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.getDimension(stringBounder);
        Dimension2D dimension2D2 = this.getStereoDimension(stringBounder);
        Dimension2D dimension2D3 = this.desc.calculateDimension(stringBounder);
        double d3 = dimension2D.getWidth();
        double d4 = dimension2D.getHeight();
        UEllipse uEllipse = new UEllipse(d3, d4);
        if (this.getSkinParam().shadowing()) {
            uEllipse.setDeltaShadow(3.0);
        }
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.getParam().setColor(this.getColor(ColorParam.usecaseBorder, this.getStereo()));
        uGraphic.getParam().setBackcolor(this.getColor(ColorParam.usecaseBackground, this.getStereo()));
        uGraphic.draw(d, d2, uEllipse);
        uGraphic.getParam().setStroke(new UStroke());
        double d5 = (dimension2D.getWidth() - dimension2D3.getWidth()) / 2.0;
        double d6 = 10.0 + dimension2D2.getHeight();
        this.desc.drawU(uGraphic, d + d5, d2 + d6);
        if (this.stereo != null) {
            double d7 = (dimension2D.getWidth() - dimension2D2.getWidth()) / 2.0;
            this.stereo.drawU(uGraphic, d + d7, d2 + 10.0);
        }
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.OVAL;
    }

    public int getShield() {
        return 0;
    }
}

