/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public final class InnerActivity
implements IEntityImage {
    private final IEntityImage im;
    private final HtmlColor borderColor;
    public static final double THICKNESS_BORDER = 1.5;

    public InnerActivity(IEntityImage iEntityImage, HtmlColor htmlColor) {
        this.im = iEntityImage;
        this.borderColor = htmlColor;
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        Dimension2D dimension2D = this.getDimension(uGraphic.getStringBounder());
        uGraphic.getParam().setColor(this.borderColor);
        uGraphic.getParam().setBackcolor(null);
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.draw(d, d2, new URectangle(dimension2D.getWidth(), dimension2D.getHeight(), 25.0, 25.0));
        uGraphic.getParam().setStroke(new UStroke());
        this.im.drawU(uGraphic, d, d2);
    }

    public HtmlColor getBackcolor() {
        return this.im.getBackcolor();
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.im.getDimension(stringBounder);
        return dimension2D;
    }

    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

