/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockArrow;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable3;
import net.sourceforge.plantuml.posimo.BezierUtils;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.posimo.PositionableUtils;
import net.sourceforge.plantuml.svek.ArithmeticStrategySum;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.Diamond;
import net.sourceforge.plantuml.svek.EntityImageNoteLink;
import net.sourceforge.plantuml.svek.Oscillator;
import net.sourceforge.plantuml.svek.Plus;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Line
implements Moveable {
    private final String ltail;
    private final String lhead;
    private final Link link;
    private DotPath dotPath;
    private final String startUid;
    private final String endUid;
    private final TextBlock startTailText;
    private final TextBlock endHeadText;
    private final TextBlock noteLabelText;
    private final int lineColor;
    private final int noteLabelColor;
    private final int startTailColor;
    private final int endHeadColor;
    private Positionable startTailLabelXY;
    private Positionable endHeadLabelXY;
    private Positionable noteLabelXY;
    private UDrawable3 endHead;
    private UDrawable3 startTail;
    private final StringBounder stringBounder;
    private final Bibliotekon bibliotekon;
    private double dx;
    private double dy;
    private boolean opale;

    public Line(String string, String string2, Link link, ColorSequence colorSequence, String string3, String string4, ISkinParam iSkinParam, StringBounder stringBounder, FontConfiguration fontConfiguration, Bibliotekon bibliotekon) {
        TextBlock textBlock;
        TextBlock textBlock2;
        if (string == null || string2 == null || link == null) {
            throw new IllegalArgumentException();
        }
        this.bibliotekon = bibliotekon;
        this.stringBounder = stringBounder;
        this.link = link;
        this.startUid = string;
        this.endUid = string2;
        this.ltail = string3;
        this.lhead = string4;
        this.lineColor = colorSequence.getValue();
        this.noteLabelColor = colorSequence.getValue();
        this.startTailColor = colorSequence.getValue();
        this.endHeadColor = colorSequence.getValue();
        if (link.getLabel() == null) {
            textBlock2 = this.getLinkArrow() == LinkArrow.NONE ? null : new DirectionalTextBlock(new TextBlockArrow(LinkArrow.DIRECT_NORMAL, fontConfiguration), new TextBlockArrow(LinkArrow.BACKWARD, fontConfiguration));
        } else {
            textBlock = TextBlockUtils.create(StringUtils.getWithNewlines(link.getLabel()), fontConfiguration, HorizontalAlignement.CENTER, iSkinParam);
            if (this.getLinkArrow() == LinkArrow.NONE) {
                textBlock2 = textBlock;
            } else {
                TextBlock textBlock3 = TextBlockUtils.mergeLR(textBlock, new TextBlockArrow(LinkArrow.DIRECT_NORMAL, fontConfiguration));
                TextBlock textBlock4 = TextBlockUtils.mergeLR(new TextBlockArrow(LinkArrow.BACKWARD, fontConfiguration), textBlock);
                textBlock2 = new DirectionalTextBlock(textBlock3, textBlock4);
            }
        }
        textBlock = link.getNote() == null ? null : TextBlockUtils.fromIEntityImage(new EntityImageNoteLink(link.getNote(), link.getNoteColor(), iSkinParam));
        this.noteLabelText = textBlock2 != null && textBlock != null ? (link.getNotePosition() == Position.LEFT ? TextBlockUtils.mergeLR(textBlock, textBlock2) : (link.getNotePosition() == Position.RIGHT ? TextBlockUtils.mergeLR(textBlock2, textBlock) : (link.getNotePosition() == Position.TOP ? TextBlockUtils.mergeTB(textBlock, textBlock2) : TextBlockUtils.mergeTB(textBlock2, textBlock)))) : (textBlock2 != null ? textBlock2 : (textBlock != null ? textBlock : null));
        this.startTailText = link.getQualifier1() == null ? null : TextBlockUtils.create(StringUtils.getWithNewlines(link.getQualifier1()), fontConfiguration, HorizontalAlignement.CENTER, iSkinParam);
        this.endHeadText = link.getQualifier2() == null ? null : TextBlockUtils.create(StringUtils.getWithNewlines(link.getQualifier2()), fontConfiguration, HorizontalAlignement.CENTER, iSkinParam);
    }

    private LinkArrow getLinkArrow() {
        return this.link.getLinkArrow();
    }

    public void appendLine(StringBuilder stringBuilder) {
        stringBuilder.append(this.startUid);
        stringBuilder.append("->");
        stringBuilder.append(this.endUid);
        stringBuilder.append("[");
        String string = this.link.getType().getSpecificDecorationSvek();
        if (!string.endsWith(",")) {
            string = string + ",";
        }
        stringBuilder.append(string);
        if (this.link.getLength() != 1) {
            stringBuilder.append("minlen=" + (this.link.getLength() - 1));
            stringBuilder.append(",");
        }
        stringBuilder.append("color=\"" + StringUtils.getAsHtml(this.lineColor) + "\"");
        if (this.noteLabelText != null) {
            stringBuilder.append(",");
            stringBuilder.append("label=<");
            Line.appendTable(stringBuilder, this.noteLabelText.calculateDimension(this.stringBounder), this.noteLabelColor);
            stringBuilder.append(">");
        }
        if (this.startTailText != null) {
            stringBuilder.append(",");
            stringBuilder.append("taillabel=<");
            Line.appendTable(stringBuilder, this.startTailText.calculateDimension(this.stringBounder), this.startTailColor);
            stringBuilder.append(">");
        }
        if (this.endHeadText != null) {
            stringBuilder.append(",");
            stringBuilder.append("headlabel=<");
            Line.appendTable(stringBuilder, this.endHeadText.calculateDimension(this.stringBounder), this.endHeadColor);
            stringBuilder.append(">");
        }
        if (this.ltail != null) {
            stringBuilder.append(",");
            stringBuilder.append("ltail=");
            stringBuilder.append(this.ltail);
        }
        if (this.lhead != null) {
            stringBuilder.append(",");
            stringBuilder.append("lhead=");
            stringBuilder.append(this.lhead);
        }
        if (this.link.isInvis()) {
            stringBuilder.append(",");
            stringBuilder.append("style=invis");
        }
        if (!this.link.isConstraint()) {
            stringBuilder.append("constraint=false,");
        }
        stringBuilder.append("];");
        SvekUtils.println(stringBuilder);
    }

    public String rankSame() {
        if (this.link.getLength() == 1) {
            return "{rank=same; " + this.getStartUid() + "; " + this.getEndUid() + "}";
        }
        return null;
    }

    public static void appendTable(StringBuilder stringBuilder, Dimension2D dimension2D, int n) {
        int n2 = (int)dimension2D.getWidth();
        int n3 = (int)dimension2D.getHeight();
        Line.appendTable(stringBuilder, n2, n3, n);
    }

    public static void appendTable(StringBuilder stringBuilder, int n, int n2, int n3) {
        stringBuilder.append("<TABLE ");
        stringBuilder.append("BGCOLOR=\"" + StringUtils.getAsHtml(n3) + "\" ");
        stringBuilder.append("FIXEDSIZE=\"TRUE\" WIDTH=\"" + n + "\" HEIGHT=\"" + n2 + "\">");
        stringBuilder.append("<TR");
        stringBuilder.append(">");
        stringBuilder.append("<TD");
        stringBuilder.append(">");
        stringBuilder.append("</TD>");
        stringBuilder.append("</TR>");
        stringBuilder.append("</TABLE>");
    }

    public final String getStartUid() {
        if (this.startUid.endsWith(":h")) {
            return this.startUid.substring(0, this.startUid.length() - 2);
        }
        return this.startUid;
    }

    public final String getEndUid() {
        if (this.endUid.endsWith(":h")) {
            return this.endUid.substring(0, this.endUid.length() - 2);
        }
        return this.endUid;
    }

    public void solveLine(String string, int n) {
        Point2D.Double double_;
        Point2D point2D;
        Point2D point2D2;
        Point2D point2D3;
        Object object;
        if (this.link.isInvis()) {
            return;
        }
        int n2 = this.getIndexFromColor(string, this.lineColor);
        if ((n2 = string.indexOf("d=\"", n2)) == -1) {
            throw new IllegalStateException();
        }
        int n3 = string.indexOf("\"", n2 + 3);
        String string2 = string.substring(n2 + 3, n3);
        this.dotPath = new DotPath(string2, n);
        SvekUtils.PointListIterator pointListIterator = new SvekUtils.PointListIterator(string.substring(n3), n);
        if (this.link.getType().getDecor2() == LinkDecor.PLUS) {
            object = pointListIterator.next();
            point2D3 = (Point2D)object.get(0);
            point2D2 = (Point2D)object.get(1);
            point2D = (Point2D)object.get(2);
            double_ = new Point2D.Double((point2D3.getX() + point2D.getX()) / 2.0, (point2D3.getY() + point2D.getY()) / 2.0);
            this.endHead = new Plus(point2D2, double_);
        } else if (this.link.getType().getDecor2() == LinkDecor.AGREGATION) {
            object = pointListIterator.next();
            point2D3 = (Point2D)object.get(0);
            point2D2 = (Point2D)object.get(1);
            point2D = (Point2D)object.get(2);
            double_ = new Point2D.Double((point2D3.getX() + point2D.getX()) / 2.0, (point2D3.getY() + point2D.getY()) / 2.0);
            this.endHead = new Diamond(point2D2, double_, false);
        } else if (this.link.getType().getDecor2() == LinkDecor.COMPOSITION) {
            object = pointListIterator.next();
            point2D3 = (Point2D)object.get(0);
            point2D2 = (Point2D)object.get(1);
            point2D = (Point2D)object.get(2);
            double_ = new Point2D.Double((point2D3.getX() + point2D.getX()) / 2.0, (point2D3.getY() + point2D.getY()) / 2.0);
            this.endHead = new Diamond(point2D2, double_, true);
        } else if (this.link.getType().getDecor2() != LinkDecor.NONE) {
            object = new UPolygon((List<Point2D.Double>)pointListIterator.next());
            this.endHead = new UDrawable3((UShape)object){
                final /* synthetic */ UShape val$sh;
                {
                    this.val$sh = uShape;
                }

                public void drawU(UGraphic uGraphic, double d, double d2) {
                    uGraphic.draw(d, d2, this.val$sh);
                }
            };
        }
        if (this.link.getType().getDecor1() == LinkDecor.PLUS) {
            object = pointListIterator.next();
            point2D3 = (Point2D)object.get(0);
            point2D2 = (Point2D)object.get(1);
            point2D = (Point2D)object.get(2);
            double_ = new Point2D.Double((point2D3.getX() + point2D.getX()) / 2.0, (point2D3.getY() + point2D.getY()) / 2.0);
            this.startTail = new Plus(point2D2, double_);
        } else if (this.link.getType().getDecor1() == LinkDecor.AGREGATION) {
            object = pointListIterator.next();
            point2D3 = (Point2D)object.get(0);
            point2D2 = (Point2D)object.get(1);
            point2D = (Point2D)object.get(2);
            double_ = new Point2D.Double((point2D3.getX() + point2D.getX()) / 2.0, (point2D3.getY() + point2D.getY()) / 2.0);
            this.startTail = new Diamond(point2D2, double_, false);
        } else if (this.link.getType().getDecor1() == LinkDecor.COMPOSITION) {
            object = pointListIterator.next();
            point2D3 = (Point2D)object.get(0);
            point2D2 = (Point2D)object.get(1);
            point2D = (Point2D)object.get(2);
            double_ = new Point2D.Double((point2D3.getX() + point2D.getX()) / 2.0, (point2D3.getY() + point2D.getY()) / 2.0);
            this.startTail = new Diamond(point2D2, double_, true);
        } else if (this.link.getType().getDecor1() != LinkDecor.NONE) {
            object = new UPolygon((List<Point2D.Double>)pointListIterator.next());
            this.startTail = new UDrawable3((UShape)object){
                final /* synthetic */ UShape val$sh;
                {
                    this.val$sh = uShape;
                }

                public void drawU(UGraphic uGraphic, double d, double d2) {
                    uGraphic.draw(d, d2, this.val$sh);
                }
            };
        }
        if (this.noteLabelText != null) {
            this.noteLabelXY = TextBlockUtils.asPositionable(this.noteLabelText, this.stringBounder, this.getXY(string, this.noteLabelColor, n));
        }
        if (this.startTailText != null) {
            this.startTailLabelXY = TextBlockUtils.asPositionable(this.startTailText, this.stringBounder, this.getXY(string, this.startTailColor, n));
        }
        if (this.endHeadText != null) {
            this.endHeadLabelXY = TextBlockUtils.asPositionable(this.endHeadText, this.stringBounder, this.getXY(string, this.endHeadColor, n));
        }
        if (!this.isOpalisable()) {
            this.setOpale(false);
        }
    }

    private boolean isOpalisable() {
        return this.dotPath.getBeziers().size() <= 1;
    }

    private Point2D.Double getXY(String string, int n, int n2) {
        int n3 = this.getIndexFromColor(string, n);
        return SvekUtils.getMinXY(SvekUtils.extractPointsList(string, n3, n2));
    }

    private int getIndexFromColor(String string, int n) {
        String string2 = "stroke=\"" + StringUtils.getAsHtml(n).toLowerCase() + "\"";
        int n2 = string.indexOf(string2);
        if (n2 != -1) {
            return n2;
        }
        string2 = ";stroke:" + StringUtils.getAsHtml(n).toLowerCase() + ";";
        n2 = string.indexOf(string2);
        if (n2 != -1) {
            return n2;
        }
        throw new IllegalStateException();
    }

    public void drawU(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor) {
        if (this.opale) {
            return;
        }
        if (this.link.isAutoLinkOfAGroup()) {
            Cluster cluster = this.bibliotekon.getCluster(this.link.getEntity1());
            d += cluster.getWidth();
            d -= this.dotPath.getStartPoint().getX() - cluster.getMinX();
        }
        d += this.dx;
        d2 += this.dy;
        if (this.link.isInvis()) {
            return;
        }
        if (this.link.getSpecificColor() != null) {
            htmlColor = this.link.getSpecificColor();
        }
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.getParam().setBackcolor(null);
        uGraphic.getParam().setStroke(this.link.getType().getStroke());
        uGraphic.draw(d, d2, this.dotPath);
        uGraphic.getParam().setStroke(new UStroke());
        if (this.startTail != null) {
            uGraphic.getParam().setColor(htmlColor);
            if (this.link.getType().getDecor1().isFill()) {
                uGraphic.getParam().setBackcolor(htmlColor);
            } else {
                uGraphic.getParam().setBackcolor(null);
            }
            this.startTail.drawU(uGraphic, d, d2);
        }
        if (this.endHead != null) {
            uGraphic.getParam().setColor(htmlColor);
            if (this.link.getType().getDecor2().isFill()) {
                uGraphic.getParam().setBackcolor(htmlColor);
            } else {
                uGraphic.getParam().setBackcolor(null);
            }
            this.endHead.drawU(uGraphic, d, d2);
        }
        if (this.noteLabelText != null) {
            this.noteLabelText.drawU(uGraphic, d + this.noteLabelXY.getPosition().getX(), d2 + this.noteLabelXY.getPosition().getY());
        }
        if (this.startTailText != null) {
            this.startTailText.drawU(uGraphic, d + this.startTailLabelXY.getPosition().getX(), d2 + this.startTailLabelXY.getPosition().getY());
        }
        if (this.endHeadText != null) {
            this.endHeadText.drawU(uGraphic, d + this.endHeadLabelXY.getPosition().getX(), d2 + this.endHeadLabelXY.getPosition().getY());
        }
    }

    public boolean isInverted() {
        return this.link.isInverted();
    }

    private double getDecorDzeta() {
        int n = this.link.getType().getDecor1().getSize();
        int n2 = this.link.getType().getDecor2().getSize();
        return n + n2;
    }

    public double getHorizontalDzeta(StringBounder stringBounder) {
        if (this.startUid.equals(this.endUid)) {
            return this.getDecorDzeta();
        }
        if (!this.isHorizontal()) {
            return 0.0;
        }
        ArithmeticStrategySum arithmeticStrategySum = new ArithmeticStrategySum();
        if (this.noteLabelText != null) {
            arithmeticStrategySum.eat(this.noteLabelText.calculateDimension(stringBounder).getWidth());
        }
        if (this.startTailText != null) {
            arithmeticStrategySum.eat(this.startTailText.calculateDimension(stringBounder).getWidth());
        }
        if (this.endHeadText != null) {
            arithmeticStrategySum.eat(this.endHeadText.calculateDimension(stringBounder).getWidth());
        }
        return arithmeticStrategySum.getResult() + this.getDecorDzeta();
    }

    private boolean isHorizontal() {
        return this.link.getLength() == 1;
    }

    public double getVerticalDzeta(StringBounder stringBounder) {
        if (this.startUid.equals(this.endUid)) {
            return this.getDecorDzeta();
        }
        if (this.isHorizontal()) {
            return 0.0;
        }
        ArithmeticStrategySum arithmeticStrategySum = new ArithmeticStrategySum();
        if (this.noteLabelText != null) {
            arithmeticStrategySum.eat(this.noteLabelText.calculateDimension(stringBounder).getHeight());
        }
        if (this.startTailText != null) {
            arithmeticStrategySum.eat(this.startTailText.calculateDimension(stringBounder).getHeight());
        }
        if (this.endHeadText != null) {
            arithmeticStrategySum.eat(this.endHeadText.calculateDimension(stringBounder).getHeight());
        }
        return arithmeticStrategySum.getResult() + this.getDecorDzeta();
    }

    public void manageCollision(Collection<Shape> collection) {
        for (Shape shape : collection) {
            Positionable positionable = PositionableUtils.addMargin(shape, 8.0, 8.0);
            if (this.startTailText != null && PositionableUtils.intersect(positionable, this.startTailLabelXY)) {
                this.startTailLabelXY = PositionableUtils.moveAwayFrom(positionable, this.startTailLabelXY);
            }
            if (this.endHeadText == null || !PositionableUtils.intersect(positionable, this.endHeadLabelXY)) continue;
            this.endHeadLabelXY = PositionableUtils.moveAwayFrom(positionable, this.endHeadLabelXY);
        }
    }

    private void avoid(Point2D.Double double_, Positionable positionable, Shape shape) {
        Oscillator oscillator = new Oscillator();
        Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
        while (this.cut(positionable, shape)) {
            Point2D.Double double_3 = oscillator.nextPosition();
            double_.setLocation(double_2.x + double_3.x, double_2.y + double_3.y);
        }
    }

    private boolean cut(Positionable positionable, Shape shape) {
        return BezierUtils.intersect(positionable, shape) || this.tooClose(positionable);
    }

    private boolean tooClose(Positionable positionable) {
        Dimension2D dimension2D;
        double d = this.dotPath.getMinDist(BezierUtils.getCenter(positionable));
        return d < (dimension2D = positionable.getSize()).getWidth() / 2.0 + 2.0 || d < dimension2D.getHeight() / 2.0 + 2.0;
    }

    @Override
    public void moveSvek(double d, double d2) {
        this.dx += d;
        this.dy += d2;
    }

    public final DotPath getDotPath() {
        DotPath dotPath = new DotPath(this.dotPath);
        dotPath.moveSvek(this.dx, this.dy);
        return dotPath;
    }

    public int getLength() {
        return this.link.getLength();
    }

    public void setOpale(boolean bl) {
        this.link.setOpale(bl);
        this.opale = bl;
    }

    public boolean isOpale() {
        return this.opale;
    }

    public boolean isHorizontalSolitary() {
        return this.link.isHorizontalSolitary();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DirectionalTextBlock
    implements TextBlock {
        private final TextBlock direct;
        private final TextBlock reverse;

        DirectionalTextBlock(TextBlock textBlock, TextBlock textBlock2) {
            this.direct = textBlock;
            this.reverse = textBlock2;
        }

        @Override
        public void drawU(UGraphic uGraphic, double d, double d2) {
            boolean bl = this.isDirect();
            if (Line.this.getLinkArrow() == LinkArrow.BACKWARD) {
                boolean bl2 = bl = !bl;
            }
            if (bl) {
                this.direct.drawU(uGraphic, d, d2);
            } else {
                this.reverse.drawU(uGraphic, d, d2);
            }
        }

        @Override
        public List<Url> getUrls() {
            boolean bl = this.isDirect();
            if (bl) {
                return this.direct.getUrls();
            }
            return this.reverse.getUrls();
        }

        @Override
        public Dimension2D calculateDimension(StringBounder stringBounder) {
            return this.direct.calculateDimension(stringBounder);
        }

        private boolean isDirect() {
            Point2D point2D = Line.this.dotPath.getStartPoint();
            Point2D point2D2 = Line.this.dotPath.getEndPoint();
            if (point2D2.getX() == point2D.getX()) {
                return point2D2.getY() > point2D.getY();
            }
            return point2D2.getX() > point2D.getX();
        }
    }
}

