/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public final class RoundedContainer {
    private final Dimension2D dim;
    private final double titleHeight;
    private final double attributeHeight;
    private final HtmlColor borderColor;
    private final HtmlColor backColor;
    private final HtmlColor imgBackcolor;
    public static final double THICKNESS_BORDER = 1.5;

    public RoundedContainer(Dimension2D dimension2D, double d, double d2, HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3) {
        this.dim = dimension2D;
        this.imgBackcolor = htmlColor3;
        this.titleHeight = d;
        this.borderColor = htmlColor;
        this.backColor = htmlColor2;
        this.attributeHeight = d2;
    }

    public void drawU(UGraphic uGraphic, double d, double d2, boolean bl) {
        uGraphic.getParam().setColor(this.borderColor);
        uGraphic.getParam().setBackcolor(this.backColor);
        uGraphic.getParam().setStroke(new UStroke(1.5));
        URectangle uRectangle = new URectangle(this.dim.getWidth(), this.dim.getHeight(), 25.0, 25.0);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.draw(d, d2, uRectangle);
        double d3 = d2 + this.titleHeight + this.attributeHeight;
        uGraphic.getParam().setBackcolor(this.imgBackcolor);
        uGraphic.getParam().setColor(this.imgBackcolor);
        uGraphic.getParam().setStroke(new UStroke());
        URectangle uRectangle2 = new URectangle(this.dim.getWidth() - 6.0, this.dim.getHeight() - this.titleHeight - 6.0 - this.attributeHeight, 25.0, 25.0);
        uGraphic.draw(d + 3.0, d3 + 3.0, uRectangle2);
        if (this.titleHeight > 0.0) {
            uGraphic.getParam().setColor(this.borderColor);
            uGraphic.getParam().setStroke(new UStroke(1.5));
            uGraphic.draw(d, d3, new ULine(this.dim.getWidth(), 0.0));
            uGraphic.getParam().setStroke(new UStroke());
        }
        if (this.attributeHeight > 0.0) {
            uGraphic.getParam().setColor(this.borderColor);
            uGraphic.getParam().setStroke(new UStroke(1.5));
            uGraphic.draw(d, d3 - this.attributeHeight, new ULine(this.dim.getWidth(), 0.0));
            uGraphic.getParam().setStroke(new UStroke());
        }
    }
}

