/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.UnusedSpace;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.skin.UDrawable;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.eps.DriverDotPathEps;
import net.sourceforge.plantuml.ugraphic.eps.DriverEllipseEps;
import net.sourceforge.plantuml.ugraphic.eps.DriverImageEps;
import net.sourceforge.plantuml.ugraphic.eps.DriverLineEps;
import net.sourceforge.plantuml.ugraphic.eps.DriverPathEps;
import net.sourceforge.plantuml.ugraphic.eps.DriverPolygonEps;
import net.sourceforge.plantuml.ugraphic.eps.DriverRectangleEps;
import net.sourceforge.plantuml.ugraphic.eps.DriverTextEps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UGraphicEps
extends AbstractUGraphic<EpsGraphics>
implements ClipContainer {
    static final Graphics2D imDummy = new BufferedImage(10, 10, 1).createGraphics();
    private UClip clip;
    private final StringBounder stringBounder = StringBounderUtils.asStringBounder(imDummy);

    public UGraphicEps(ColorMapper colorMapper, EpsStrategy epsStrategy) {
        this(colorMapper, epsStrategy, epsStrategy.creatEpsGraphics());
    }

    private UGraphicEps(ColorMapper colorMapper, EpsStrategy epsStrategy, EpsGraphics epsGraphics) {
        super(colorMapper, epsGraphics);
        this.registerDriver(URectangle.class, new DriverRectangleEps(this));
        this.registerDriver(UText.class, new DriverTextEps(imDummy, this, epsStrategy));
        this.registerDriver(ULine.class, new DriverLineEps(this));
        this.registerDriver(UPolygon.class, new DriverPolygonEps(this));
        this.registerDriver(UEllipse.class, new DriverEllipseEps());
        this.registerDriver(UImage.class, new DriverImageEps());
        this.registerDriver(UPath.class, new DriverPathEps());
        this.registerDriver(DotPath.class, new DriverDotPathEps());
    }

    public void close() {
        this.getEpsGraphics().close();
    }

    public String getEPSCode() {
        return this.getEpsGraphics().getEPSCode();
    }

    public EpsGraphics getEpsGraphics() {
        return (EpsGraphics)this.getGraphicObject();
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public void drawEps(String string, double d, double d2) {
        ((EpsGraphics)this.getGraphicObject()).drawEps(string, d, d2);
    }

    @Override
    public void setClip(UClip uClip) {
        this.clip = uClip == null ? null : uClip.translate(this.getTranslateX(), this.getTranslateY());
    }

    @Override
    public UClip getClip() {
        return this.clip;
    }

    @Override
    public void centerChar(double d, double d2, char c, UFont uFont) {
        UnusedSpace unusedSpace = UnusedSpace.getUnusedSpace(uFont, c);
        double d3 = d - unusedSpace.getCenterX() - 0.5;
        double d4 = d2 - unusedSpace.getCenterY() - 0.5;
        TextLayout textLayout = new TextLayout("" + c, uFont.getFont(), imDummy.getFontRenderContext());
        ((EpsGraphics)this.getGraphicObject()).setStrokeColor(this.getColorMapper().getMappedColor(this.getParam().getColor()));
        DriverTextEps.drawPathIterator((EpsGraphics)this.getGraphicObject(), d3 + this.getTranslateX(), d4 + this.getTranslateY(), textLayout.getOutline(null).getPathIterator(null));
    }

    public static String getEpsString(ColorMapper colorMapper, EpsStrategy epsStrategy, UDrawable uDrawable) throws IOException {
        UGraphicEps uGraphicEps = new UGraphicEps(colorMapper, epsStrategy);
        uDrawable.drawU(uGraphicEps);
        return uGraphicEps.getEPSCode();
    }

    public static void copyEpsToFile(ColorMapper colorMapper, UDrawable uDrawable, File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(file);
        EpsStrategy epsStrategy = EpsStrategy.getDefault2();
        printWriter.print(UGraphicEps.getEpsString(colorMapper, epsStrategy, uDrawable));
        printWriter.close();
    }

    @Override
    public void setAntiAliasing(boolean bl) {
    }

    @Override
    public void startUrl(Url url) {
        ((EpsGraphics)this.getGraphicObject()).openLink(url.getUrl());
    }

    @Override
    public void closeAction() {
        ((EpsGraphics)this.getGraphicObject()).closeLink();
    }
}

