/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverRectangleG2d
extends DriverShadowedG2d
implements UDriver<Graphics2D> {
    private final double dpiFactor;
    private final EnsureVisible visible;

    public DriverRectangleG2d(double d, EnsureVisible ensureVisible) {
        this.dpiFactor = d;
        this.visible = ensureVisible;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, Graphics2D graphics2D) {
        HtmlColor htmlColor;
        graphics2D.setStroke(new BasicStroke((float)uParam.getStroke().getThickness()));
        URectangle uRectangle = (URectangle)uShape;
        double d3 = uRectangle.getRx();
        double d4 = uRectangle.getRy();
        RectangularShape rectangularShape = d3 == 0.0 && d4 == 0.0 ? new Rectangle2D.Double(d, d2, uRectangle.getWidth(), uRectangle.getHeight()) : new RoundRectangle2D.Double(d, d2, uRectangle.getWidth(), uRectangle.getHeight(), d3, d4);
        this.visible.ensureVisible(d, d2);
        this.visible.ensureVisible(d + uRectangle.getWidth(), d2 + uRectangle.getHeight());
        if (uRectangle.getDeltaShadow() != 0.0) {
            this.drawShadow(graphics2D, rectangularShape, uRectangle.getDeltaShadow(), this.dpiFactor);
        }
        if ((htmlColor = uParam.getBackcolor()) instanceof HtmlColorGradient) {
            HtmlColorGradient htmlColorGradient = (HtmlColorGradient)htmlColor;
            char c = htmlColorGradient.getPolicy();
            GradientPaint gradientPaint = c == '-' ? new GradientPaint((float)d, (float)(d2 + uRectangle.getHeight()) / 2.0f, colorMapper.getMappedColor(htmlColorGradient.getColor1()), (float)(d + uRectangle.getWidth()), (float)(d2 + uRectangle.getHeight()) / 2.0f, colorMapper.getMappedColor(htmlColorGradient.getColor2())) : (c == '/' ? new GradientPaint((float)d, (float)(d2 + uRectangle.getHeight()), colorMapper.getMappedColor(htmlColorGradient.getColor1()), (float)(d + uRectangle.getWidth()), (float)d2, colorMapper.getMappedColor(htmlColorGradient.getColor2())) : (c == '|' ? new GradientPaint((float)(d + uRectangle.getWidth()) / 2.0f, (float)d2, colorMapper.getMappedColor(htmlColorGradient.getColor1()), (float)(d + uRectangle.getWidth()) / 2.0f, (float)(d2 + uRectangle.getHeight()), colorMapper.getMappedColor(htmlColorGradient.getColor2())) : new GradientPaint((float)d, (float)d2, colorMapper.getMappedColor(htmlColorGradient.getColor1()), (float)(d + uRectangle.getWidth()), (float)(d2 + uRectangle.getHeight()), colorMapper.getMappedColor(htmlColorGradient.getColor2()))));
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(rectangularShape);
            if (uParam.getColor() != null) {
                graphics2D.setColor(colorMapper.getMappedColor(uParam.getColor()));
                DriverLineG2d.manageStroke(uParam, graphics2D);
                graphics2D.draw(rectangularShape);
            }
        } else {
            if (uParam.getBackcolor() != null) {
                graphics2D.setColor(colorMapper.getMappedColor(uParam.getBackcolor()));
                DriverLineG2d.manageStroke(uParam, graphics2D);
                graphics2D.fill(rectangularShape);
            }
            if (uParam.getColor() != null && !uParam.getColor().equals(uParam.getBackcolor())) {
                graphics2D.setColor(colorMapper.getMappedColor(uParam.getColor()));
                DriverLineG2d.manageStroke(uParam, graphics2D);
                graphics2D.draw(rectangularShape);
            }
        }
    }
}

