/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class DriverShadowedG2d {
    private final Color color = new Color(170, 170, 170);
    private final Color colorLine = new Color(30, 30, 30);

    private ConvolveOp getConvolveOp(int n, double d) {
        n = (int)((double)n * d);
        int n2 = n * n;
        float f = n2;
        float f2 = (float)(1.0 / (double)f);
        float[] fArray = new float[n2];
        for (int i = 0; i < n2; ++i) {
            fArray[i] = f2;
        }
        Kernel kernel = new Kernel(n, n, fArray);
        return new ConvolveOp(kernel, 1, null);
    }

    protected void drawShadow(Graphics2D graphics2D, Shape shape, double d, double d2) {
        if (d2 < 1.0) {
            d2 = 1.0;
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d3 = (rectangle2D.getMaxX() + d * 2.0 + 6.0) * d2;
        double d4 = (rectangle2D.getMaxY() + d * 2.0 + 6.0) * d2;
        BufferedImage bufferedImage = new BufferedImage((int)d3, (int)d4, 2);
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        graphics2D2.scale(d2, d2);
        graphics2D2.translate(d - rectangle2D.getMinX(), d - rectangle2D.getMinY());
        boolean bl = shape instanceof Line2D.Double;
        if (bl) {
            graphics2D2.setColor(this.colorLine);
            graphics2D2.draw(shape);
        } else {
            graphics2D2.setColor(this.color);
            graphics2D2.fill(shape);
        }
        graphics2D2.dispose();
        ConvolveOp convolveOp = this.getConvolveOp(6, d2);
        bufferedImage = convolveOp.filter(bufferedImage, null);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.scale(1.0 / d2, 1.0 / d2);
        graphics2D.drawImage((Image)bufferedImage, (int)(rectangle2D.getMinX() * d2), (int)(rectangle2D.getMinY() * d2), null);
        graphics2D.setTransform(affineTransform);
    }
}

