/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.txt;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.asciiart.TextStringBounder;
import net.sourceforge.plantuml.asciiart.TranslatedCharArea;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.asciiart.UmlCharAreaImpl;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGroup;
import net.sourceforge.plantuml.ugraphic.UGroupNull;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UText;

public class UGraphicTxt
extends AbstractCommonUGraphic {
    private final UmlCharArea charArea = new UmlCharAreaImpl();
    private int lastPrint = 0;

    public UGraphicTxt() {
        super(new ColorMapperIdentity());
    }

    public StringBounder getStringBounder() {
        return new TextStringBounder();
    }

    public void draw(double d, double d2, UShape uShape) {
        if (uShape instanceof UText) {
            UText uText = (UText)uShape;
            this.charArea.drawStringLR(uText.getText(), 0, this.lastPrint);
            ++this.lastPrint;
            if (uText.getFontConfiguration().containsStyle(FontStyle.WAVE)) {
                this.charArea.drawHLine('^', this.lastPrint, 0, uText.getText().length());
                ++this.lastPrint;
            }
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void setClip(UClip uClip) {
    }

    public void centerChar(double d, double d2, char c, UFont uFont) {
        throw new UnsupportedOperationException();
    }

    public final UmlCharArea getCharArea() {
        return new TranslatedCharArea(this.charArea, (int)this.getTranslateX(), (int)this.getTranslateY());
    }

    public void setAntiAliasing(boolean bl) {
    }

    public void startUrl(Url url) {
    }

    public void closeAction() {
    }

    public UGroup createGroup() {
        return new UGroupNull();
    }
}

