/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.DiagramType;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.PSystemBasicFactory;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemVersionFactory
implements PSystemBasicFactory {
    private PSystemVersion system;

    public void init(String string) {
    }

    public boolean executeLine(String string) {
        try {
            if (string.matches("(?i)^(authors?|about)\\s*$")) {
                this.system = PSystemVersion.createShowAuthors();
                return true;
            }
            if (string.matches("(?i)^version\\s*$")) {
                this.system = PSystemVersion.createShowVersion();
                return true;
            }
            if (string.matches("(?i)^testdot\\s*$")) {
                this.system = PSystemVersion.createTestDot();
                return true;
            }
            if (string.matches("(?i)^checkversion\\s*$")) {
                this.system = PSystemVersion.createCheckVersions(null, null);
                return true;
            }
            Pattern pattern = Pattern.compile("(?i)^checkversion\\(proxy=([\\w.]+),port=(\\d+)\\)$");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                this.system = PSystemVersion.createCheckVersions(string2, string3);
                return true;
            }
            Pattern pattern2 = Pattern.compile("(?i)^checkversion\\(proxy=([\\w.]+)\\)$");
            Matcher matcher2 = pattern2.matcher(string);
            if (matcher2.matches()) {
                String string4 = matcher2.group(1);
                this.system = PSystemVersion.createCheckVersions(string4, "80");
                return true;
            }
        }
        catch (IOException iOException) {
            Log.error("Error " + iOException);
        }
        return false;
    }

    public PSystemVersion getSystem() {
        return this.system;
    }

    public DiagramType getDiagramType() {
        return DiagramType.UML;
    }
}

