/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmi;

import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.xmi.IXmiClassDiagram;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmiClassDiagramStandard
implements IXmiClassDiagram {
    private final ClassDiagram classDiagram;
    private final Document document;
    private final Element ownedElement;
    private final Set<IEntity> done = new HashSet<IEntity>();

    public XmiClassDiagramStandard(ClassDiagram classDiagram) throws ParserConfigurationException {
        this.classDiagram = classDiagram;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.newDocument();
        this.document.setXmlVersion("1.0");
        this.document.setXmlStandalone(true);
        Element element = this.document.createElement("XMI");
        element.setAttribute("xmi.version", "1.1");
        element.setAttribute("xmlns:UML", "href://org.omg/UML/1.3");
        this.document.appendChild(element);
        Element element2 = this.document.createElement("XMI.header");
        element.appendChild(element2);
        Element element3 = this.document.createElement("XMI.metamodel");
        element3.setAttribute("xmi.name", "UML");
        element3.setAttribute("xmi.version", "1.3");
        element2.appendChild(element3);
        Element element4 = this.document.createElement("XMI.content");
        element.appendChild(element4);
        Element element5 = this.document.createElement("UML:Model");
        element5.setAttribute("xmi.id", "model1");
        element5.setAttribute("name", "PlantUML");
        element4.appendChild(element5);
        this.ownedElement = this.document.createElement("UML:Namespace.ownedElement");
        element5.appendChild(this.ownedElement);
        for (IEntity iEntity : classDiagram.getEntities().values()) {
            Element element6 = this.createEntityNode(iEntity);
            this.ownedElement.appendChild(element6);
            this.done.add(iEntity);
        }
    }

    public static String forXMI(String string) {
        return string.replace(':', ' ');
    }

    private void addLink(Link link) {
        String string = "ass" + UniqueSequence.getValue();
        Element element = this.document.createElement("UML:Association");
        element.setAttribute("xmi.id", string);
        element.setAttribute("namespace", "model1");
        if (link.getLabel() != null) {
            element.setAttribute("name", XmiClassDiagramStandard.forXMI(link.getLabel()));
        }
        Element element2 = this.document.createElement("UML:Association.connection");
        Element element3 = this.document.createElement("UML:AssociationEnd");
        element3.setAttribute("xmi.id", "end" + UniqueSequence.getValue());
        element3.setAttribute("association", string);
        element3.setAttribute("type", link.getEntity1().getUid());
        if (link.getQualifier1() != null) {
            element3.setAttribute("name", XmiClassDiagramStandard.forXMI(link.getQualifier1()));
        }
        Element element4 = this.document.createElement("UML:AssociationEnd.participant");
        element3.appendChild(element4);
        element2.appendChild(element3);
        Element element5 = this.document.createElement("UML:AssociationEnd");
        element5.setAttribute("xmi.id", "end" + UniqueSequence.getValue());
        element5.setAttribute("association", string);
        element5.setAttribute("type", link.getEntity2().getUid());
        if (link.getQualifier2() != null) {
            element5.setAttribute("name", XmiClassDiagramStandard.forXMI(link.getQualifier2()));
        }
        Element element6 = this.document.createElement("UML:AssociationEnd.participant");
        element5.appendChild(element6);
        element2.appendChild(element5);
        element.appendChild(element2);
        this.ownedElement.appendChild(element);
    }

    private void addExtension(Link link, String string) {
        Element element = this.document.createElement("UML:Generalization");
        element.setAttribute("xmi.id", string);
        element.setAttribute("namespace", "model1");
        if (link.getLabel() != null) {
            element.setAttribute("name", XmiClassDiagramStandard.forXMI(link.getLabel()));
        }
        if (link.getType().getDecor1() == LinkDecor.EXTENDS) {
            element.setAttribute("child", link.getEntity1().getUid());
            element.setAttribute("parent", link.getEntity2().getUid());
        } else if (link.getType().getDecor2() == LinkDecor.EXTENDS) {
            element.setAttribute("child", link.getEntity2().getUid());
            element.setAttribute("parent", link.getEntity1().getUid());
        } else {
            throw new IllegalStateException();
        }
        this.ownedElement.appendChild(element);
    }

    private Element createEntityNode(IEntity iEntity) {
        Element element;
        Element element2 = this.document.createElement("UML:Class");
        element2.setAttribute("xmi.id", iEntity.getUid());
        element2.setAttribute("name", ((Object)iEntity.getDisplay2().get(0)).toString());
        element2.setAttribute("namespace", "model1");
        Element element3 = this.document.createElement("UML:Classifier.feature");
        element2.appendChild(element3);
        for (Member member : iEntity.getFieldsToDisplay()) {
            element = this.document.createElement("UML:Attribute");
            element.setAttribute("xmi.id", "att" + UniqueSequence.getValue());
            element.setAttribute("name", member.getDisplay(false));
            element3.appendChild(element);
        }
        for (Member member : iEntity.getMethodsToDisplay()) {
            element = this.document.createElement("UML:Operation");
            element.setAttribute("xmi.id", "att" + UniqueSequence.getValue());
            element.setAttribute("name", member.getDisplay(false));
            element3.appendChild(element);
        }
        return element2;
    }

    private Element createEntityNodeRef(IEntity iEntity) {
        Element element = this.document.createElement("UML:Class");
        element.setAttribute("xmi.idref", iEntity.getUid());
        return element;
    }

    public void transformerXml(OutputStream outputStream) throws TransformerException, ParserConfigurationException {
        DOMSource dOMSource = new DOMSource(this.document);
        StreamResult streamResult = new StreamResult(outputStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(dOMSource, streamResult);
    }
}

