/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.acearth.PSystemXearthFactory;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagramFactory;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagramFactory3;
import net.sourceforge.plantuml.api.PSystemFactory;
import net.sourceforge.plantuml.api.Performance;
import net.sourceforge.plantuml.classdiagram.ClassDiagramFactory;
import net.sourceforge.plantuml.compositediagram.CompositeDiagramFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.creole.PSystemCreoleFactory;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagramFactory;
import net.sourceforge.plantuml.directdot.PSystemDotFactory;
import net.sourceforge.plantuml.ditaa.PSystemDitaaFactory;
import net.sourceforge.plantuml.donors.PSystemDonorsFactory;
import net.sourceforge.plantuml.eggs.PSystemAppleTwoFactory;
import net.sourceforge.plantuml.eggs.PSystemCharlieFactory;
import net.sourceforge.plantuml.eggs.PSystemEggFactory;
import net.sourceforge.plantuml.eggs.PSystemLostFactory;
import net.sourceforge.plantuml.eggs.PSystemPathFactory;
import net.sourceforge.plantuml.eggs.PSystemRIPFactory;
import net.sourceforge.plantuml.flowdiagram.FlowDiagramFactory;
import net.sourceforge.plantuml.font.PSystemListFontsFactory;
import net.sourceforge.plantuml.jcckit.PSystemJcckitFactory;
import net.sourceforge.plantuml.jungle.PSystemTreeFactory;
import net.sourceforge.plantuml.logo.PSystemLogoFactory;
import net.sourceforge.plantuml.objectdiagram.ObjectDiagramFactory;
import net.sourceforge.plantuml.openiconic.PSystemListOpenIconicFactory;
import net.sourceforge.plantuml.openiconic.PSystemOpenIconicFactory;
import net.sourceforge.plantuml.oregon.PSystemOregonFactory;
import net.sourceforge.plantuml.postit.PostIdDiagramFactory;
import net.sourceforge.plantuml.printskin.PrintSkinFactory;
import net.sourceforge.plantuml.project2.PSystemProjectFactory2;
import net.sourceforge.plantuml.salt.PSystemSaltFactory;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagramFactory;
import net.sourceforge.plantuml.statediagram.StateDiagramFactory;
import net.sourceforge.plantuml.sudoku.PSystemSudokuFactory;
import net.sourceforge.plantuml.turing.PSystemTuringFactory;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.PSystemLicenseFactory;
import net.sourceforge.plantuml.version.PSystemVersionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemBuilder {
    public static final long startTime = System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Diagram createPSystem(List<? extends CharSequence> list) {
        try {
            Object object;
            List<PSystemFactory> list2 = this.getAllFactories();
            DiagramType diagramType = DiagramType.getTypeFromArobaseStart(list.get(0).toString());
            UmlSource umlSource = new UmlSource(list, diagramType == DiagramType.UML);
            DiagramType diagramType2 = umlSource.getDiagramType();
            ArrayList<PSystemError> arrayList = new ArrayList<PSystemError>();
            Object object2 = list2.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (diagramType2 != object.getDiagramType()) continue;
                Diagram diagram = object.createSystem(umlSource);
                if (this.isOk(diagram)) {
                    Diagram diagram2 = diagram;
                    return diagram2;
                }
                arrayList.add((PSystemError)diagram);
            }
            object = object2 = this.merge(arrayList);
            return object;
        }
        finally {
            Performance.incDiagramCount();
        }
    }

    private List<PSystemFactory> getAllFactories() {
        ArrayList<PSystemFactory> arrayList = new ArrayList<PSystemFactory>();
        arrayList.add(new SequenceDiagramFactory());
        arrayList.add(new ClassDiagramFactory());
        arrayList.add(new ActivityDiagramFactory());
        arrayList.add(new DescriptionDiagramFactory());
        arrayList.add(new StateDiagramFactory());
        arrayList.add(new ActivityDiagramFactory3());
        arrayList.add(new CompositeDiagramFactory());
        arrayList.add(new ObjectDiagramFactory());
        arrayList.add(new PostIdDiagramFactory());
        arrayList.add(new PrintSkinFactory());
        arrayList.add(new PSystemLicenseFactory());
        arrayList.add(new PSystemVersionFactory());
        arrayList.add(new PSystemDonorsFactory());
        arrayList.add(new PSystemListFontsFactory());
        arrayList.add(new PSystemOpenIconicFactory());
        arrayList.add(new PSystemListOpenIconicFactory());
        arrayList.add(new PSystemSaltFactory(DiagramType.SALT));
        arrayList.add(new PSystemSaltFactory(DiagramType.UML));
        arrayList.add(new PSystemDotFactory(DiagramType.DOT));
        arrayList.add(new PSystemDotFactory(DiagramType.UML));
        if (License.getCurrent() == License.GPL) {
            arrayList.add(new PSystemDitaaFactory(DiagramType.DITAA));
            arrayList.add(new PSystemDitaaFactory(DiagramType.UML));
            arrayList.add(new PSystemJcckitFactory(DiagramType.JCCKIT));
            arrayList.add(new PSystemJcckitFactory(DiagramType.UML));
            arrayList.add(new PSystemLogoFactory());
            arrayList.add(new PSystemSudokuFactory());
            arrayList.add(new PSystemTuringFactory());
        }
        arrayList.add(new PSystemCreoleFactory());
        arrayList.add(new PSystemEggFactory());
        arrayList.add(new PSystemAppleTwoFactory());
        arrayList.add(new PSystemRIPFactory());
        arrayList.add(new PSystemLostFactory());
        arrayList.add(new PSystemPathFactory());
        arrayList.add(new PSystemOregonFactory());
        arrayList.add(new PSystemCharlieFactory());
        if (License.getCurrent() == License.GPL) {
            arrayList.add(new PSystemXearthFactory());
        }
        arrayList.add(new PSystemProjectFactory2());
        arrayList.add(new FlowDiagramFactory());
        arrayList.add(new PSystemTreeFactory(DiagramType.JUNGLE));
        return arrayList;
    }

    private PSystemError merge(Collection<PSystemError> collection) {
        UmlSource umlSource = null;
        ArrayList<ErrorUml> arrayList = new ArrayList<ErrorUml>();
        for (PSystemError pSystemError : collection) {
            if (pSystemError.getSource() != null && umlSource == null) {
                umlSource = pSystemError.getSource();
            }
            arrayList.addAll(pSystemError.getErrorsUml());
        }
        if (umlSource == null) {
            throw new IllegalStateException();
        }
        return new PSystemError(umlSource, arrayList);
    }

    private boolean isOk(Diagram diagram) {
        return diagram != null && !(diagram instanceof PSystemError);
    }
}

