/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemError
extends AbstractPSystem {
    private final int higherErrorPosition;
    private final List<ErrorUml> printedErrors;

    private String getSuggestColor(boolean bl) {
        if (bl) {
            return "black";
        }
        return "white";
    }

    private String getRed(boolean bl) {
        if (bl) {
            return "#CD0A0A";
        }
        return "red";
    }

    public PSystemError(UmlSource umlSource, List<ErrorUml> list) {
        this.setSource(umlSource);
        int n = this.getHigherErrorPosition(ErrorUmlType.EXECUTION_ERROR, list);
        int n2 = this.getHigherErrorPosition(ErrorUmlType.SYNTAX_ERROR, list);
        if (n == Integer.MIN_VALUE && n2 == Integer.MIN_VALUE) {
            throw new IllegalStateException();
        }
        if (n >= n2) {
            this.higherErrorPosition = n;
            this.printedErrors = this.getErrorsAt(n, ErrorUmlType.EXECUTION_ERROR, list);
        } else {
            assert (n2 > n);
            this.higherErrorPosition = n2;
            this.printedErrors = this.getErrorsAt(n2, ErrorUmlType.SYNTAX_ERROR, list);
        }
    }

    public PSystemError(UmlSource umlSource, ErrorUml errorUml) {
        this(umlSource, Collections.singletonList(errorUml));
    }

    @Override
    public ImageData exportDiagram(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        if (fileFormatOption.getFileFormat() == FileFormat.ATXT || fileFormatOption.getFileFormat() == FileFormat.UTXT) {
            UGraphicTxt uGraphicTxt = new UGraphicTxt();
            UmlCharArea umlCharArea = uGraphicTxt.getCharArea();
            umlCharArea.drawStringsLR(this.getTextStrings(), 0, 0);
            umlCharArea.print(new PrintStream(outputStream));
            return new ImageDataSimple(1, 1);
        }
        boolean bl = fileFormatOption.isUseRedForError();
        GraphicStrings graphicStrings = GraphicStrings.createDefault(this.getHtmlStrings(bl), bl);
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, graphicStrings.getBackcolor(), this.getMetadata(), null, 0.0, 0.0, null);
        imageBuilder.addUDrawable(graphicStrings);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption.getFileFormat(), outputStream);
    }

    private List<String> getTextStrings() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.higherErrorPosition - 4 + 1;
        if (n2 <= 0) {
            n = 0;
        } else {
            if (n2 == 1) {
                arrayList.add("... (skipping 1 line) ...");
            } else {
                arrayList.add("... (skipping " + n2 + " lines) ...");
            }
            n = this.higherErrorPosition - 4 + 1;
        }
        for (int i = n; i < this.higherErrorPosition; ++i) {
            arrayList.add(this.getSource().getLine(i));
        }
        String string = this.getSource().getLine(this.higherErrorPosition);
        String string2 = StringUtils.hideComparatorCharacters(string);
        if (StringUtils.isNotEmpty(string2)) {
            arrayList.add(string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append("^");
        }
        arrayList.add(stringBuilder.toString());
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (ErrorUml iterator : this.printedErrors) {
            linkedHashSet.add(iterator.getError());
        }
        for (String string3 : linkedHashSet) {
            arrayList.add(" " + string3);
        }
        boolean bl = true;
        for (String string4 : this.getSuggest()) {
            if (bl) {
                arrayList.add(" " + string4);
            } else {
                arrayList.add(string4);
            }
            bl = false;
        }
        return arrayList;
    }

    private List<String> getHtmlStrings(boolean bl) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.higherErrorPosition - 4 + 1;
        if (n2 <= 0) {
            n = 0;
        } else {
            if (n2 == 1) {
                arrayList.add("... (skipping 1 line) ...");
            } else {
                arrayList.add("... (skipping " + n2 + " lines) ...");
            }
            n = this.higherErrorPosition - 4 + 1;
        }
        for (int i = n; i < this.higherErrorPosition; ++i) {
            arrayList.add(StringUtils.hideComparatorCharacters(this.getSource().getLine(i)));
        }
        String string = this.getSource().getLine(this.higherErrorPosition);
        String string2 = StringUtils.hideComparatorCharacters(string);
        if (StringUtils.isNotEmpty(string2)) {
            arrayList.add("<w:" + this.getRed(bl) + ">" + string2 + "</w>");
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (ErrorUml iterator : this.printedErrors) {
            linkedHashSet.add(iterator.getError());
        }
        for (String string3 : linkedHashSet) {
            arrayList.add(" <color:" + this.getRed(bl) + ">" + string3 + "</color>");
        }
        boolean bl2 = true;
        for (String string4 : this.getSuggest()) {
            if (bl2) {
                arrayList.add(" <color:" + this.getSuggestColor(bl) + "><i>" + string4 + "</i></color>");
            } else {
                arrayList.add("<color:" + this.getSuggestColor(bl) + ">" + StringUtils.hideComparatorCharacters(string4) + "</color>");
            }
            bl2 = false;
        }
        return arrayList;
    }

    public List<String> getSuggest() {
        boolean bl = false;
        for (ErrorUml object : this.printedErrors) {
            if (!object.hasSuggest()) continue;
            bl = true;
        }
        if (!bl) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add("Did you mean:");
        for (ErrorUml errorUml : this.printedErrors) {
            if (!errorUml.hasSuggest()) continue;
            arrayList.add(errorUml.getSuggest().getSuggestedLine());
        }
        return Collections.unmodifiableList(arrayList);
    }

    private Collection<ErrorUml> getErrors(ErrorUmlType errorUmlType, List<ErrorUml> list) {
        LinkedHashSet<ErrorUml> linkedHashSet = new LinkedHashSet<ErrorUml>();
        for (ErrorUml errorUml : list) {
            if (errorUml.getType() != errorUmlType) continue;
            linkedHashSet.add(errorUml);
        }
        return linkedHashSet;
    }

    private int getHigherErrorPosition(ErrorUmlType errorUmlType, List<ErrorUml> list) {
        int n = Integer.MIN_VALUE;
        for (ErrorUml errorUml : this.getErrors(errorUmlType, list)) {
            if (errorUml.getPosition() <= n) continue;
            n = errorUml.getPosition();
        }
        return n;
    }

    private List<ErrorUml> getErrorsAt(int n, ErrorUmlType errorUmlType, List<ErrorUml> list) {
        ArrayList<ErrorUml> arrayList = new ArrayList<ErrorUml>();
        for (ErrorUml errorUml : this.getErrors(errorUmlType, list)) {
            if (errorUml.getPosition() != n || !StringUtils.isNotEmpty(errorUml.getError())) continue;
            arrayList.add(errorUml);
        }
        return arrayList;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Error)", this.getClass());
    }

    public final int getHigherErrorPosition() {
        return this.higherErrorPosition;
    }

    public final Collection<ErrorUml> getErrorsUml() {
        return Collections.unmodifiableCollection(this.printedErrors);
    }

    @Override
    public String getWarningOrError() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getDescription());
        stringBuilder.append('\n');
        for (CharSequence charSequence : this.getTitle()) {
            stringBuilder.append(charSequence);
            stringBuilder.append('\n');
        }
        stringBuilder.append('\n');
        for (String string : this.getSuggest()) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

