/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandActivity3
extends SingleLineCommand2<ActivityDiagram3> {
    public static final String ENDING_GROUP = "(;|(?<![/|<>}\\]])(?:[/<}\\]])|(?<!\\</?\\w{1,5})(?<!\\<img[^>]{1,999})(?<!\\<\\$\\w{1,999})(?<!\\>)(?:\\>)|(?<!\\|.{1,999})(?:\\|))";

    public CommandActivity3() {
        super(CommandActivity3.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("COLOR", "(?::?(#\\w+[-\\\\|/]?\\w+))?"), new RegexLeaf(":"), new RegexLeaf("LABEL", "(.*)"), new RegexLeaf("STYLE", ENDING_GROUP), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 activityDiagram3, RegexResult regexResult) {
        Object object;
        Url url;
        if (regexResult.get("URL", 0) == null) {
            url = null;
        } else {
            object = new UrlBuilder(activityDiagram3.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            url = ((UrlBuilder)object).getUrl(regexResult.get("URL", 0));
        }
        object = activityDiagram3.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLOR", 0));
        BoxStyle boxStyle = BoxStyle.fromChar(regexResult.get("STYLE", 0).charAt(0));
        activityDiagram3.addActivity(Display.getWithNewlines(regexResult.get("LABEL", 0)), (HtmlColor)object, boxStyle, url);
        return CommandExecutionResult.ok();
    }
}

