/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileAssemblySimple;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactoryDelegator;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileHeightFixed;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMarged;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBlackBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileFactoryDelegatorCreateFork
extends FtileFactoryDelegator {
    private final double spaceArroundBlackBar = 20.0;
    private final double barHeight = 6.0;
    private final double xMargin = 14.0;
    private final Rose rose = new Rose();

    public FtileFactoryDelegatorCreateFork(FtileFactory ftileFactory, ISkinParam iSkinParam) {
        super(ftileFactory, iSkinParam);
    }

    @Override
    public Ftile createFork(Swimlane swimlane, List<Ftile> list) {
        HtmlColor htmlColor = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.activityBar);
        HtmlColor htmlColor2 = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.activityArrow);
        FtileGeometry ftileGeometry = super.createFork(swimlane, list).calculateDimension(this.getStringBounder());
        double d = ((Dimension2D)ftileGeometry).getHeight() + 40.0;
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>();
        for (Ftile object2 : list) {
            arrayList.add(new FtileHeightFixed(new FtileMarged(object2, 14.0), d));
        }
        Object object3 = super.createFork(swimlane, arrayList);
        ArrayList<Connection> arrayList2 = new ArrayList<Connection>();
        FtileBlackBlock ftileBlackBlock = new FtileBlackBlock(this.shadowing(), htmlColor, ((Ftile)arrayList.get(0)).getSwimlaneIn());
        double d2 = 0.0;
        for (Ftile ftile : arrayList) {
            FtileGeometry ftileGeometry2 = ftile.calculateDimension(this.getStringBounder());
            arrayList2.add(new ConnectionIn(ftileBlackBlock, ftile, d2, htmlColor2));
            arrayList2.add(new ConnectionOut(ftile, ftileBlackBlock, d2, htmlColor2, d));
            d2 += ((Dimension2D)ftileGeometry2).getWidth();
        }
        object3 = FtileUtils.addConnection((Ftile)object3, arrayList2);
        ftileBlackBlock.setDimenstion(object3.calculateDimension(this.getStringBounder()).getWidth(), 6.0);
        FtileAssemblySimple ftileAssemblySimple = new FtileAssemblySimple(ftileBlackBlock, (Ftile)object3);
        return new FtileAssemblySimple(ftileAssemblySimple, ftileBlackBlock);
    }

    class ConnectionOut
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final double x;
        private final HtmlColor arrowColor;
        private final double height;

        public ConnectionOut(Ftile ftile, Ftile ftile2, double d, HtmlColor htmlColor, double d2) {
            super(ftile, ftile2);
            this.x = d;
            this.arrowColor = htmlColor;
            this.height = d2;
        }

        public void drawU(UGraphic uGraphic) {
            uGraphic = uGraphic.apply(new UTranslate(this.x, 0.0));
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(FtileFactoryDelegatorCreateFork.this.getStringBounder());
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(ftileGeometry.getLeft(), ftileGeometry.getOutY());
            snake.addPoint(ftileGeometry.getLeft(), this.height);
            uGraphic.draw(snake);
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            uGraphic = uGraphic.apply(new UTranslate(this.x, 0.0));
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(FtileFactoryDelegatorCreateFork.this.getStringBounder());
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Point2D.Double double_ = new Point2D.Double(ftileGeometry.getLeft(), ftileGeometry.getOutY());
            Point2D.Double double_2 = new Point2D.Double(ftileGeometry.getLeft(), this.height);
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            Point2D point2D = uTranslate.getTranslated(double_);
            Point2D point2D2 = uTranslate2.getTranslated(double_2);
            double d = point2D2.getY() - 14.0;
            snake.addPoint(point2D);
            snake.addPoint(point2D.getX(), d);
            snake.addPoint(point2D2.getX(), d);
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }
    }

    class ConnectionIn
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final double x;
        private final HtmlColor arrowColor;

        public ConnectionIn(Ftile ftile, Ftile ftile2, double d, HtmlColor htmlColor) {
            super(ftile, ftile2);
            this.x = d;
            this.arrowColor = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            uGraphic = uGraphic.apply(new UTranslate(this.x, 0.0));
            FtileGeometry ftileGeometry = this.getFtile2().calculateDimension(FtileFactoryDelegatorCreateFork.this.getStringBounder());
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(ftileGeometry.getLeft(), 0.0);
            snake.addPoint(ftileGeometry.getLeft(), ftileGeometry.getInY());
            uGraphic.draw(snake);
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            uGraphic = uGraphic.apply(new UTranslate(this.x, 0.0));
            FtileGeometry ftileGeometry = this.getFtile2().calculateDimension(FtileFactoryDelegatorCreateFork.this.getStringBounder());
            Point2D.Double double_ = new Point2D.Double(ftileGeometry.getLeft(), 0.0);
            Point2D.Double double_2 = new Point2D.Double(ftileGeometry.getLeft(), ftileGeometry.getInY());
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            Point2D point2D = uTranslate.getTranslated(double_);
            Point2D point2D2 = uTranslate2.getTranslated(double_2);
            double d = point2D.getY() + 4.0;
            snake.addPoint(point2D);
            snake.addPoint(point2D.getX(), d);
            snake.addPoint(point2D2.getX(), d);
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }
    }
}

