/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMarged;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FloatingNote;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileGroup
extends AbstractFtile {
    private final double diffYY2 = 20.0;
    private final Ftile inner;
    private final TextBlock name;
    private final TextBlock headerNote;
    private final HtmlColor color;
    private final HtmlColor backColor;
    private final HtmlColor titleColor;

    public FtileGroup(Ftile ftile, Display display, Display display2, HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, ISkinParam iSkinParam) {
        super(ftile.shadowing());
        this.backColor = htmlColor2 == null ? HtmlColorUtils.WHITE : htmlColor2;
        this.inner = new FtileMarged(ftile, 10.0);
        this.color = htmlColor;
        this.titleColor = htmlColor3;
        UFont uFont = new UFont("Serif", 0, 14);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK, iSkinParam.getHyperlinkColor(), iSkinParam.useUnderlineForHyperlink());
        this.name = display == null ? TextBlockUtils.empty(0.0, 0.0) : TextBlockUtils.create(display, fontConfiguration, HorizontalAlignment.LEFT, iSkinParam);
        this.headerNote = display2 == null ? TextBlockUtils.empty(0.0, 0.0) : new FloatingNote(display2, iSkinParam);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.inner.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.inner.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.inner.getSwimlaneOut();
    }

    private double diffHeightTitle(StringBounder stringBounder) {
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        return Math.max(25.0, dimension2D.getHeight() + 20.0);
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        double d = this.suppWidth(stringBounder);
        return new UTranslate(d / 2.0, this.diffHeightTitle(stringBounder) + this.headerNoteHeight(stringBounder));
    }

    public double suppWidth(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.inner.calculateDimension(stringBounder);
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.headerNote.calculateDimension(stringBounder);
        double d = MathUtils.max(ftileGeometry.getWidth(), dimension2D.getWidth() + 20.0, dimension2D2.getWidth() + 20.0) - ftileGeometry.getWidth();
        return d;
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.inner.calculateDimension(stringBounder);
        double d = this.suppWidth(stringBounder);
        double d2 = ftileGeometry.getWidth() + d;
        double d3 = ftileGeometry.getHeight() + this.diffHeightTitle(stringBounder) + 20.0 + this.headerNoteHeight(stringBounder);
        double d4 = this.diffHeightTitle(stringBounder) + this.headerNoteHeight(stringBounder);
        if (ftileGeometry.hasPointOut()) {
            return new FtileGeometry(d2, d3, ftileGeometry.getLeft() + d / 2.0, ftileGeometry.getInY() + d4, ftileGeometry.getOutY() + d4);
        }
        return new FtileGeometry(d2, d3, ftileGeometry.getLeft() + d / 2.0, ftileGeometry.getInY() + d4);
    }

    private double headerNoteHeight(StringBounder stringBounder) {
        return this.headerNote.calculateDimension(stringBounder).getHeight();
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        FtileGeometry ftileGeometry = this.calculateDimension(stringBounder);
        SymbolContext symbolContext = new SymbolContext(this.backColor, HtmlColorUtils.BLACK).withShadow(this.shadowing()).withStroke(new UStroke(2.0));
        USymbol.FRAME.asBig(this.name, TextBlockUtils.empty(0.0, 0.0), ((Dimension2D)ftileGeometry).getWidth(), ((Dimension2D)ftileGeometry).getHeight(), symbolContext).drawU(uGraphic);
        Dimension2D dimension2D = this.headerNote.calculateDimension(stringBounder);
        this.headerNote.drawU(uGraphic.apply(new UTranslate(((Dimension2D)ftileGeometry).getWidth() - dimension2D.getWidth() - 10.0, this.diffHeightTitle(uGraphic.getStringBounder()) - 10.0)));
        uGraphic.apply(this.getTranslate(stringBounder)).draw(this.inner);
    }
}

