/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileBlackBlock
extends AbstractFtile {
    private double width;
    private double height;
    private final HtmlColor colorBar;
    private final Swimlane swimlane;

    public FtileBlackBlock(boolean bl, HtmlColor htmlColor, Swimlane swimlane) {
        super(bl);
        this.colorBar = htmlColor;
        this.swimlane = swimlane;
    }

    public void setDimenstion(double d, double d2) {
        this.height = d2;
        this.width = d;
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        return new FtileGeometry(this.width, this.height, this.width / 2.0, 0.0, this.height);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        URectangle uRectangle = new URectangle(this.width, this.height, 5.0, 5.0);
        if (this.shadowing()) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.apply(new UChangeColor(this.colorBar)).apply(new UChangeBackColor(this.colorBar)).draw(uRectangle);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }
}

