/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.classdiagram.command.GenericRegexProducer;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateClass
extends SingleLineCommand2<ClassDiagram> {
    public static final String CODE = "[^%s{}%g<>]+";

    public CommandCreateClass() {
        super(CommandCreateClass.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(interface|enum|annotation|abstract[%s]+class|abstract|class)[%s]+"), new RegexOr(new RegexConcat(new RegexLeaf("DISPLAY1", "[%g]([^%g]+)[%g]"), new RegexLeaf("[%s]+as[%s]+"), new RegexLeaf("CODE1", "([^%s{}%g<>]+)")), new RegexConcat(new RegexLeaf("CODE2", "([^%s{}%g<>]+)"), new RegexLeaf("[%s]+as[%s]+"), new RegexLeaf("DISPLAY2", "[%g]([^%g]+)[%g]")), new RegexLeaf("CODE3", "([^%s{}%g<>]+)"), new RegexLeaf("CODE4", "[%g]([^%g]+)[%g]")), new RegexLeaf("GENERIC", "(?:[%s]*\\<(" + GenericRegexProducer.PATTERN + ")\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("[%s]*"), new RegexLeaf("LINECOLOR", "(?:##(?:\\[(dotted|dashed|bold)\\])?(\\w+)?)?"), new RegexLeaf("EXTENDS", "([%s]+(extends)[%s]+((?:\\.|::)?[\\p{L}0-9_]+(?:(?:\\.|::)[\\p{L}0-9_]+)*(?:\\s*,\\s*(?:\\.|::)?[\\p{L}0-9_]+(?:(?:\\.|::)[\\p{L}0-9_]+)*)*))?"), new RegexLeaf("IMPLEMENTS", "([%s]+(implements)[%s]+((?:\\.|::)?[\\p{L}0-9_]+(?:(?:\\.|::)[\\p{L}0-9_]+)*(?:\\s*,\\s*(?:\\.|::)?[\\p{L}0-9_]+(?:(?:\\.|::)[\\p{L}0-9_]+)*)*))?"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram classDiagram, RegexResult regexResult) {
        String string;
        ILeaf iLeaf;
        LeafType leafType = LeafType.getLeafType(StringUtils.goUpperCase(regexResult.get("TYPE", 0)));
        Code code = Code.of(regexResult.getLazzy("CODE", 0)).eventuallyRemoveStartingAndEndingDoubleQuote("\"([:");
        String string2 = regexResult.getLazzy("DISPLAY", 0);
        String string3 = regexResult.get("STEREO", 0);
        String string4 = regexResult.get("GENERIC", 0);
        if (classDiagram.leafExist(code)) {
            iLeaf = classDiagram.getOrCreateLeaf(code, leafType, null);
            iLeaf.muteToType(leafType, null);
        } else {
            iLeaf = classDiagram.createLeaf(code, Display.getWithNewlines(string2), leafType, null);
        }
        if (string3 != null) {
            iLeaf.setStereotype(new Stereotype(string3, classDiagram.getSkinParam().getCircledCharacterRadius(), classDiagram.getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null, false), classDiagram.getSkinParam().getIHtmlColorSet()));
        }
        if (string4 != null) {
            iLeaf.setGeneric(string4);
        }
        if ((string = regexResult.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(classDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(string);
            iLeaf.addUrl(url);
        }
        iLeaf.setSpecificBackcolor(classDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLOR", 0)));
        iLeaf.setSpecificLineColor(classDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("LINECOLOR", 1)));
        CommandCreateClassMultilines.applyStroke(iLeaf, regexResult.get("LINECOLOR", 0));
        CommandCreateClassMultilines.manageExtends("EXTENDS", classDiagram, regexResult, iLeaf);
        CommandCreateClassMultilines.manageExtends("IMPLEMENTS", classDiagram, regexResult, iLeaf);
        return CommandExecutionResult.ok();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        EXTENDS,
        IMPLEMENTS;

    }
}

