/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.EnumSet;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.skin.VisibilityModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandHideShow3
extends SingleLineCommand2<UmlDiagram> {
    private static final EnumSet<EntityPortion> PORTION_METHOD = EnumSet.of(EntityPortion.METHOD);
    private static final EnumSet<EntityPortion> PORTION_MEMBER = EnumSet.of(EntityPortion.FIELD, EntityPortion.METHOD);
    private static final EnumSet<EntityPortion> PORTION_FIELD = EnumSet.of(EntityPortion.FIELD);

    public CommandHideShow3() {
        super(CommandHideShow3.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("COMMAND", "(hide|show)"), new RegexLeaf("[%s]+"), new RegexLeaf("VISIBILITY", "((?:public|private|protected|package)?(?:[,%s]+(?:public|private|protected|package))*)"), new RegexLeaf("[%s]+"), new RegexLeaf("PORTION", "(members?|attributes?|fields?|methods?)"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(UmlDiagram umlDiagram, RegexResult regexResult) {
        if (umlDiagram instanceof ClassDiagram) {
            return this.executeArgClass((ClassDiagram)umlDiagram, regexResult);
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgClass(ClassDiagram classDiagram, RegexResult regexResult) {
        Set<EntityPortion> set = this.getEntityPortion(regexResult.get("PORTION", 0));
        EnumSet<VisibilityModifier> enumSet = EnumSet.noneOf(VisibilityModifier.class);
        StringTokenizer stringTokenizer = new StringTokenizer(StringUtils.goLowerCase(regexResult.get("VISIBILITY", 0)), " ,");
        while (stringTokenizer.hasMoreTokens()) {
            this.addVisibilities(stringTokenizer.nextToken(), set, enumSet);
        }
        classDiagram.hideOrShow(enumSet, regexResult.get("COMMAND", 0).equalsIgnoreCase("show"));
        return CommandExecutionResult.ok();
    }

    private void addVisibilities(String string, Set<EntityPortion> set, Set<VisibilityModifier> set2) {
        if (string.equals("public") && set.contains((Object)EntityPortion.FIELD)) {
            set2.add(VisibilityModifier.PUBLIC_FIELD);
        }
        if (string.equals("public") && set.contains((Object)EntityPortion.METHOD)) {
            set2.add(VisibilityModifier.PUBLIC_METHOD);
        }
        if (string.equals("private") && set.contains((Object)EntityPortion.FIELD)) {
            set2.add(VisibilityModifier.PRIVATE_FIELD);
        }
        if (string.equals("private") && set.contains((Object)EntityPortion.METHOD)) {
            set2.add(VisibilityModifier.PRIVATE_METHOD);
        }
        if (string.equals("protected") && set.contains((Object)EntityPortion.FIELD)) {
            set2.add(VisibilityModifier.PROTECTED_FIELD);
        }
        if (string.equals("protected") && set.contains((Object)EntityPortion.METHOD)) {
            set2.add(VisibilityModifier.PROTECTED_METHOD);
        }
        if (string.equals("package") && set.contains((Object)EntityPortion.FIELD)) {
            set2.add(VisibilityModifier.PACKAGE_PRIVATE_FIELD);
        }
        if (string.equals("package") && set.contains((Object)EntityPortion.METHOD)) {
            set2.add(VisibilityModifier.PACKAGE_PRIVATE_METHOD);
        }
    }

    private Set<EntityPortion> getEntityPortion(String string) {
        String string2 = StringUtils.goLowerCase(string.substring(0, 3));
        if (string2.equals("met")) {
            return PORTION_METHOD;
        }
        if (string2.equals("mem")) {
            return PORTION_MEMBER;
        }
        if (string2.equals("att") || string2.equals("fie")) {
            return PORTION_FIELD;
        }
        throw new IllegalArgumentException();
    }
}

