/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.core.Diagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleLineCommand2<S extends Diagram>
implements Command<S> {
    private final RegexConcat pattern;

    public SingleLineCommand2(RegexConcat regexConcat) {
        if (regexConcat == null) {
            throw new IllegalArgumentException();
        }
        if (!regexConcat.getPattern().startsWith("^") || !regexConcat.getPattern().endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + regexConcat.getPattern());
        }
        this.pattern = regexConcat;
    }

    @Override
    public String[] getDescription() {
        return new String[]{this.pattern.getPattern()};
    }

    @Override
    public final CommandControl isValid(List<String> list) {
        if (list.size() != 1) {
            return CommandControl.NOT_OK;
        }
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        String string = list.get(0).trim();
        boolean bl = this.pattern.match(string);
        if (bl) {
            this.actionIfCommandValid();
        }
        return bl ? CommandControl.OK : CommandControl.NOT_OK;
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    @Override
    public final CommandExecutionResult execute(S s, List<String> list) {
        if (list.size() != 1) {
            throw new IllegalArgumentException();
        }
        String string = list.get(0).trim();
        if (this.isForbidden(string)) {
            return CommandExecutionResult.error("Forbidden line " + string);
        }
        RegexResult regexResult = this.pattern.matcher(string);
        if (regexResult == null) {
            return CommandExecutionResult.error("Cannot parse line " + string);
        }
        if (s instanceof PSystemError) {
            return CommandExecutionResult.error("PSystemError cannot be cast");
        }
        return this.executeArg(s, regexResult);
    }

    protected boolean isForbidden(String string) {
        return false;
    }

    protected abstract CommandExecutionResult executeArg(S var1, RegexResult var2);
}

