/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;

public class CommandCreoleColorAndSizeChange
implements Command {
    private final Pattern pattern;
    public static final String fontPattern = "\\<font(?:[%s]+size[%s]*=[%s]*[%g]?(\\d+)[%g]?|[%s]+color[%s]*=[%s]*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>";

    public static Command create() {
        return new CommandCreoleColorAndSizeChange("^(?i)(\\<font(?:[%s]+size[%s]*=[%s]*[%g]?(\\d+)[%g]?|[%s]+color[%s]*=[%s]*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>(.*?)\\</font\\>)");
    }

    public static Command createEol() {
        return new CommandCreoleColorAndSizeChange("^(?i)(\\<font(?:[%s]+size[%s]*=[%s]*[%g]?(\\d+)[%g]?|[%s]+color[%s]*=[%s]*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>(.*))$");
    }

    private CommandCreoleColorAndSizeChange(String string) {
        this.pattern = MyPattern.cmpile(string);
    }

    public int matchingSize(String string) {
        Matcher matcher = this.pattern.matcher(string);
        if (!matcher.find()) {
            return 0;
        }
        return matcher.group(1).length();
    }

    public String executeAndGetRemaining(String string, StripeSimple stripeSimple) {
        FontConfiguration fontConfiguration;
        Matcher matcher = this.pattern.matcher(string);
        if (!matcher.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fontConfiguration2 = fontConfiguration = stripeSimple.getActualFontConfiguration();
        if (matcher.group(2) != null) {
            fontConfiguration2 = fontConfiguration2.changeSize(Integer.parseInt(matcher.group(2)));
        }
        if (matcher.group(3) != null) {
            HtmlColor htmlColor = HtmlColorSet.getInstance().getColorIfValid(matcher.group(3));
            fontConfiguration2 = fontConfiguration2.changeColor(htmlColor);
        }
        stripeSimple.setActualFontConfiguration(fontConfiguration2);
        stripeSimple.analyzeAndAdd(matcher.group(4));
        stripeSimple.setActualFontConfiguration(fontConfiguration);
        return string.substring(matcher.group(1).length());
    }
}

