/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontPosition;

public class CommandCreoleExposantChange
implements Command {
    private final Pattern pattern;
    private final FontPosition position;

    private CommandCreoleExposantChange(String string, FontPosition fontPosition) {
        this.pattern = MyPattern.cmpile(string);
        this.position = fontPosition;
    }

    public static Command create(FontPosition fontPosition) {
        return new CommandCreoleExposantChange("^(?i)(\\<" + fontPosition.getHtmlTag() + "\\>" + "(.*?)\\</" + fontPosition.getHtmlTag() + "\\>)", fontPosition);
    }

    public int matchingSize(String string) {
        Matcher matcher = this.pattern.matcher(string);
        if (!matcher.find()) {
            return 0;
        }
        return matcher.group(2).length();
    }

    public String executeAndGetRemaining(String string, StripeSimple stripeSimple) {
        Matcher matcher = this.pattern.matcher(string);
        if (!matcher.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fontConfiguration = stripeSimple.getActualFontConfiguration();
        FontConfiguration fontConfiguration2 = fontConfiguration.changeFontPosition(this.position);
        stripeSimple.setActualFontConfiguration(fontConfiguration2);
        stripeSimple.analyzeAndAdd(matcher.group(2));
        stripeSimple.setActualFontConfiguration(fontConfiguration);
        return string.substring(matcher.group(1).length());
    }
}

