/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BodyEnhanced
implements TextBlock {
    private TextBlock area2;
    private final FontConfiguration titleConfig;
    private final List<String> rawBody;
    private final FontParam fontParam;
    private final ISkinParam skinParam;
    private final boolean lineFirst;
    private final HorizontalAlignment align;
    private final boolean manageHorizontalLine;
    private final boolean manageModifier;
    private final List<Url> urls = new ArrayList<Url>();

    public BodyEnhanced(List<String> list, FontParam fontParam, ISkinParam iSkinParam, boolean bl) {
        this.rawBody = new ArrayList<String>(list);
        this.fontParam = fontParam;
        this.skinParam = iSkinParam;
        this.titleConfig = new FontConfiguration(iSkinParam.getFont(fontParam, null, false), new Rose().getFontColor(iSkinParam, fontParam), iSkinParam.getHyperlinkColor(), iSkinParam.useUnderlineForHyperlink());
        this.lineFirst = true;
        this.align = HorizontalAlignment.LEFT;
        this.manageHorizontalLine = true;
        this.manageModifier = bl;
    }

    public BodyEnhanced(Display display, FontParam fontParam, ISkinParam iSkinParam, HorizontalAlignment horizontalAlignment, Stereotype stereotype, boolean bl, boolean bl2) {
        this.rawBody = new ArrayList<String>();
        for (CharSequence charSequence : display) {
            this.rawBody.add(charSequence.toString());
        }
        this.fontParam = fontParam;
        this.skinParam = iSkinParam;
        this.titleConfig = new FontConfiguration(iSkinParam, fontParam, stereotype);
        this.lineFirst = false;
        this.align = horizontalAlignment;
        this.manageHorizontalLine = bl;
        this.manageModifier = bl2;
    }

    private TextBlock decorate(StringBounder stringBounder, TextBlock textBlock, char c, TextBlock textBlock2) {
        if (c == '\u0000') {
            return textBlock;
        }
        if (textBlock2 == null) {
            return new TextBlockLineBefore(TextBlockUtils.withMargin(textBlock, 6.0, 4.0), c);
        }
        Dimension2D dimension2D = textBlock2.calculateDimension(stringBounder);
        TextBlockLineBefore textBlockLineBefore = new TextBlockLineBefore(TextBlockUtils.withMargin(textBlock, 6.0, 6.0, dimension2D.getHeight() / 2.0, 4.0), c, textBlock2);
        return TextBlockUtils.withMargin(textBlockLineBefore, 0.0, 0.0, dimension2D.getHeight() / 2.0, 0.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getArea(stringBounder).calculateDimension(stringBounder);
    }

    private TextBlock getArea(StringBounder stringBounder) {
        if (this.area2 != null) {
            return this.area2;
        }
        this.urls.clear();
        ArrayList<TextBlock> arrayList = new ArrayList<TextBlock>();
        char c = this.lineFirst ? (char)'_' : '\u0000';
        TextBlock textBlock = null;
        ArrayList<Member> arrayList2 = new ArrayList<Member>();
        for (String string : this.rawBody) {
            if (this.manageHorizontalLine && BodyEnhanced.isBlockSeparator(string)) {
                arrayList.add(this.decorate(stringBounder, new MethodsOrFieldsArea(arrayList2, this.fontParam, this.skinParam, this.align), c, textBlock));
                c = string.charAt(0);
                textBlock = this.getTitle(string, this.skinParam);
                arrayList2 = new ArrayList();
                continue;
            }
            Member member = new Member(string, StringUtils.isMethod(string), this.manageModifier);
            arrayList2.add(member);
            if (member.getUrl() == null) continue;
            this.urls.add(member.getUrl());
        }
        arrayList.add(this.decorate(stringBounder, new MethodsOrFieldsArea(arrayList2, this.fontParam, this.skinParam, this.align), c, textBlock));
        this.area2 = arrayList.size() == 1 ? (TextBlock)arrayList.get(0) : new TextBlockVertical2(arrayList, this.align);
        return this.area2;
    }

    public static boolean isBlockSeparator(String string) {
        if (string.startsWith("--") && string.endsWith("--")) {
            return true;
        }
        if (string.startsWith("==") && string.endsWith("==")) {
            return true;
        }
        if (string.startsWith("..") && string.endsWith("..") && !string.equals("...")) {
            return true;
        }
        return string.startsWith("__") && string.endsWith("__");
    }

    private TextBlock getTitle(String string, ISkinSimple iSkinSimple) {
        if (string.length() <= 4) {
            return null;
        }
        string = string.substring(2, string.length() - 2).trim();
        return TextBlockUtils.create(Display.getWithNewlines(string), this.titleConfig, HorizontalAlignment.LEFT, iSkinSimple);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        this.getArea(uGraphic.getStringBounder()).drawU(uGraphic);
    }

    public List<Url> getUrls() {
        return Collections.unmodifiableList(this.urls);
    }
}

