/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.Map;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Code
implements Comparable<Code> {
    private final String fullName;
    private final String separator;

    private Code(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.fullName = string;
        this.separator = string2;
    }

    public Code withSeparator(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.separator != null && !this.separator.equals(string)) {
            throw new IllegalStateException();
        }
        return new Code(this.fullName, string);
    }

    public static Code of(String string) {
        return Code.of(string, null);
    }

    public static Code of(String string, String string2) {
        if (string == null) {
            return null;
        }
        return new Code(string, string2);
    }

    public final String getFullName() {
        return this.fullName;
    }

    public String toString() {
        return this.fullName + "(" + this.separator + ")";
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    public boolean equals(Object object) {
        Code code = (Code)object;
        return this.fullName.equals(code.fullName);
    }

    public Code addSuffix(String string) {
        return new Code(this.fullName + string, this.separator);
    }

    @Override
    public int compareTo(Code code) {
        return this.fullName.compareTo(code.fullName);
    }

    public Code eventuallyRemoveStartingAndEndingDoubleQuote(String string) {
        return Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(this.fullName, string), this.separator);
    }

    private final String getNamespace(Map<Code, ILeaf> map) {
        int n;
        String string = this.getFullName();
        if (this.separator == null) {
            throw new IllegalArgumentException(this.toString());
        }
        do {
            if ((n = string.lastIndexOf(this.separator)) != -1) continue;
            return null;
        } while (map.containsKey(Code.of(string = string.substring(0, n), this.separator)));
        return string;
    }

    public final Code getShortName(Map<Code, ILeaf> map) {
        if (this.separator == null) {
            throw new IllegalArgumentException();
        }
        String string = this.getFullName();
        String string2 = this.getNamespace(map);
        if (string2 == null) {
            return Code.of(string, this.separator);
        }
        return Code.of(string.substring(string2.length() + this.separator.length()), this.separator);
    }

    public final Code getFullyQualifiedCode(IGroup iGroup) {
        if (this.separator == null) {
            throw new IllegalArgumentException();
        }
        String string = this.getFullName();
        if (string.startsWith(this.separator)) {
            return Code.of(string.substring(this.separator.length()), this.separator);
        }
        if (string.contains(this.separator)) {
            return Code.of(string, this.separator);
        }
        if (EntityUtils.groupRoot(iGroup)) {
            return Code.of(string, this.separator);
        }
        Code code = iGroup.getNamespace2();
        if (code == null) {
            return Code.of(string, this.separator);
        }
        return Code.of(code.fullName + this.separator + string, this.separator);
    }
}

