/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.skin.ArrowConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessage
implements Event {
    private final Display label;
    private final ArrowConfiguration arrowConfiguration;
    private final List<LifeEvent> lifeEvents = new ArrayList<LifeEvent>();
    private Display notes;
    private NotePosition notePosition;
    private HtmlColor noteBackColor;
    private Url urlNote;
    private final Url url;
    private final String messageNumber;
    private double posYendLevel;

    public AbstractMessage(Display display, ArrowConfiguration arrowConfiguration, String string) {
        this.url = display.initUrl();
        this.label = display.removeUrl(this.url);
        this.arrowConfiguration = arrowConfiguration;
        this.messageNumber = string;
    }

    @Override
    public final Url getUrl() {
        if (this.url == null) {
            return this.urlNote;
        }
        return this.url;
    }

    @Override
    public boolean hasUrl() {
        if (this.notes != null && this.notes.hasUrl()) {
            return true;
        }
        if (this.label != null && this.label.hasUrl()) {
            return true;
        }
        return this.getUrl() != null;
    }

    public final boolean addLifeEvent(LifeEvent lifeEvent) {
        HashSet<Participant> hashSet = new HashSet<Participant>();
        for (LifeEvent lifeEvent2 : this.lifeEvents) {
            if (lifeEvent2.getType() != LifeEventType.DEACTIVATE && lifeEvent2.getType() != LifeEventType.DESTROY) continue;
            hashSet.add(lifeEvent2.getParticipant());
        }
        if (lifeEvent.getType() == LifeEventType.ACTIVATE && hashSet.contains(lifeEvent.getParticipant())) {
            return false;
        }
        this.lifeEvents.add(lifeEvent);
        return true;
    }

    public final boolean isCreate() {
        for (LifeEvent lifeEvent : this.lifeEvents) {
            if (lifeEvent.getType() != LifeEventType.CREATE) continue;
            return true;
        }
        return false;
    }

    public final boolean isActivateAndDeactive() {
        if (this.lifeEvents.size() < 2) {
            return false;
        }
        return this.lifeEvents.get(0).getType() == LifeEventType.ACTIVATE && (this.lifeEvents.get(1).getType() == LifeEventType.DEACTIVATE || this.lifeEvents.get(1).getType() == LifeEventType.DESTROY);
    }

    public final List<LifeEvent> getLiveEvents() {
        return Collections.unmodifiableList(this.lifeEvents);
    }

    public final Display getLabel() {
        return this.label;
    }

    public final ArrowConfiguration getArrowConfiguration() {
        return this.arrowConfiguration;
    }

    public final Display getNote() {
        return this.notes == null ? this.notes : this.notes;
    }

    public final Url getUrlNote() {
        return this.urlNote;
    }

    public final void setNote(Display display, NotePosition notePosition, String string, Url url) {
        if (notePosition != NotePosition.LEFT && notePosition != NotePosition.RIGHT) {
            throw new IllegalArgumentException();
        }
        this.notes = display;
        this.urlNote = url;
        this.notePosition = this.overideNotePosition(notePosition);
        this.noteBackColor = HtmlColorSet.getInstance().getColorIfValid(string);
    }

    protected NotePosition overideNotePosition(NotePosition notePosition) {
        return notePosition;
    }

    public final HtmlColor getSpecificBackColor() {
        return this.noteBackColor;
    }

    public final NotePosition getNotePosition() {
        return this.notePosition;
    }

    public final String getMessageNumber() {
        return this.messageNumber;
    }

    public boolean isActivate() {
        for (LifeEvent lifeEvent : this.lifeEvents) {
            if (lifeEvent.getType() != LifeEventType.ACTIVATE) continue;
            return true;
        }
        return false;
    }

    public boolean isDeactivate() {
        for (LifeEvent lifeEvent : this.lifeEvents) {
            if (lifeEvent.getType() != LifeEventType.DEACTIVATE) continue;
            return true;
        }
        return false;
    }

    public abstract boolean compatibleForCreate(Participant var1);

    public abstract boolean isSelfMessage();

    public void setPosYendLevel(double d) {
        this.posYendLevel = d;
    }

    public double getPosYendLevel() {
        return this.posYendLevel;
    }
}

