/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Delay;
import net.sourceforge.plantuml.sequencediagram.Divider;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Grouping;
import net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import net.sourceforge.plantuml.sequencediagram.GroupingStart;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.HSpace;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.Notes;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.sequencediagram.Reference;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramFileMakerPuma2;
import net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramTxtMaker;
import net.sourceforge.plantuml.skin.ProtectedSkin;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.skin.SkinUtils;
import net.sourceforge.plantuml.skin.rose.Rose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceDiagram
extends UmlDiagram {
    private final Map<String, Participant> participants = new LinkedHashMap<String, Participant>();
    private final List<Event> events = new ArrayList<Event>();
    private final Map<Participant, ParticipantEnglober> participantEnglobers2 = new HashMap<Participant, ParticipantEnglober>();
    private Skin skin = new ProtectedSkin(new Rose());
    private AbstractMessage lastMessage;
    private boolean ignoreNewpage = false;
    private int autonewpage = -1;
    private Delay lastDelay;
    private final Stack<Message> activationState = new Stack();
    private LifeEvent pendingCreate = null;
    private final List<GroupingStart> openGroupings = new ArrayList<GroupingStart>();
    private Integer messageNumber = null;
    private int incrementMessageNumber;
    private DecimalFormat decimalFormat;
    private boolean showFootbox = true;
    private ParticipantEnglober participantEnglober;
    private boolean autoactivate;

    @Deprecated
    public Participant getOrCreateParticipant(String string) {
        return this.getOrCreateParticipant(string, Display.getWithNewlines(string));
    }

    public Participant getOrCreateParticipant(String string, Display display) {
        Participant participant = this.participants.get(string);
        if (participant == null) {
            participant = new Participant(ParticipantType.PARTICIPANT, string, display);
            this.participants.put(string, participant);
            this.participantEnglobers2.put(participant, this.participantEnglober);
        }
        return participant;
    }

    public AbstractMessage getLastMessage() {
        return this.lastMessage;
    }

    public Participant createNewParticipant(ParticipantType participantType, String string, Display display) {
        if (this.participants.containsKey(string)) {
            throw new IllegalArgumentException();
        }
        if (display == null) {
            display = Display.getWithNewlines(string);
        }
        Participant participant = new Participant(participantType, string, display);
        this.participants.put(string, participant);
        this.participantEnglobers2.put(participant, this.participantEnglober);
        return participant;
    }

    public Map<String, Participant> participants() {
        return Collections.unmodifiableMap(this.participants);
    }

    public String addMessage(AbstractMessage abstractMessage) {
        this.lastMessage = abstractMessage;
        this.lastDelay = null;
        this.events.add(abstractMessage);
        if (this.pendingCreate != null) {
            if (!abstractMessage.compatibleForCreate(this.pendingCreate.getParticipant())) {
                return "After create command, you have to send a message to \"" + this.pendingCreate.getParticipant() + "\"";
            }
            abstractMessage.addLifeEvent(this.pendingCreate);
            this.pendingCreate = null;
        }
        return null;
    }

    public void addNote(Note note, boolean bl) {
        if (bl && this.events.size() > 0) {
            Event event = this.events.get(this.events.size() - 1);
            if (event instanceof Note) {
                Notes notes = new Notes((Note)event, note);
                this.events.set(this.events.size() - 1, notes);
                return;
            }
            if (event instanceof Notes) {
                ((Notes)event).add(note);
                return;
            }
        }
        this.events.add(note);
    }

    public void newpage(Display display) {
        if (this.ignoreNewpage) {
            return;
        }
        this.events.add(new Newpage(display));
    }

    public void ignoreNewpage() {
        this.ignoreNewpage = true;
    }

    public final int getAutonewpage() {
        return this.autonewpage;
    }

    public void setAutonewpage(int n) {
        this.autonewpage = n;
    }

    public void divider(Display display) {
        this.events.add(new Divider(display));
    }

    public void hspace() {
        this.events.add(new HSpace());
    }

    public void hspace(int n) {
        this.events.add(new HSpace(n));
    }

    public void delay(Display display) {
        Delay delay = new Delay(display);
        this.events.add(delay);
        this.lastDelay = delay;
    }

    public List<Event> events() {
        return Collections.unmodifiableList(this.events);
    }

    private FileMaker getSequenceDiagramPngMaker(FileFormatOption fileFormatOption) {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.ATXT || fileFormat == FileFormat.UTXT) {
            return new SequenceDiagramTxtMaker(this, fileFormat);
        }
        return new SequenceDiagramFileMakerPuma2(this, this.skin, fileFormatOption);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        FileMaker fileMaker = this.getSequenceDiagramPngMaker(fileFormatOption);
        return fileMaker.createOne(outputStream, n, fileFormatOption.isWithMetadata());
    }

    public Message getActivatingMessage() {
        if (this.activationState.empty()) {
            return null;
        }
        return this.activationState.peek();
    }

    public String activate(Participant participant, LifeEventType lifeEventType, HtmlColor htmlColor) {
        if (this.lastDelay != null) {
            return "You cannot Activate/Deactivate just after a ...";
        }
        LifeEvent lifeEvent = new LifeEvent(participant, lifeEventType, htmlColor);
        this.events.add(lifeEvent);
        if (lifeEventType == LifeEventType.CREATE) {
            this.pendingCreate = lifeEvent;
            return null;
        }
        if (this.lastMessage == null) {
            if (lifeEventType == LifeEventType.ACTIVATE) {
                participant.incInitialLife(htmlColor);
                return null;
            }
            return "Only activate command can occur before message are send";
        }
        if (lifeEventType == LifeEventType.ACTIVATE && this.lastMessage instanceof Message) {
            this.activationState.push((Message)this.lastMessage);
        } else if (lifeEventType == LifeEventType.DEACTIVATE && !this.activationState.empty()) {
            this.activationState.pop();
        }
        boolean bl = this.lastMessage.addLifeEvent(lifeEvent);
        if (bl) {
            return null;
        }
        return "Activate/Deactivate already done on " + participant.getCode();
    }

    public boolean grouping(String string, String string2, GroupingType groupingType, HtmlColor htmlColor, HtmlColor htmlColor2) {
        if (groupingType != GroupingType.START && this.openGroupings.size() == 0) {
            return false;
        }
        GroupingStart groupingStart = this.openGroupings.size() > 0 ? this.openGroupings.get(0) : null;
        Grouping grouping = groupingType == GroupingType.START ? new GroupingStart(string, string2, htmlColor, htmlColor2, groupingStart) : new GroupingLeaf(string, string2, groupingType, htmlColor, htmlColor2, groupingStart);
        this.events.add(grouping);
        if (groupingType == GroupingType.START) {
            this.openGroupings.add(0, (GroupingStart)grouping);
        } else if (groupingType == GroupingType.END) {
            this.openGroupings.remove(0);
        }
        return true;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(" + this.participants.size() + " participants)", this.getClass());
    }

    public boolean changeSkin(String string) {
        Skin skin = SkinUtils.loadSkin(string);
        Integer n = new Integer(1);
        if (skin != null && n.equals(skin.getProtocolVersion())) {
            this.skin = new ProtectedSkin(skin);
            return true;
        }
        return false;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public final void goAutonumber(int n, int n2, DecimalFormat decimalFormat) {
        this.messageNumber = n;
        this.incrementMessageNumber = n2;
        this.decimalFormat = decimalFormat;
    }

    public String getNextMessageNumber() {
        if (this.messageNumber == null) {
            return null;
        }
        Integer n = this.messageNumber;
        this.messageNumber = this.messageNumber + this.incrementMessageNumber;
        return this.decimalFormat.format(n);
    }

    public boolean isShowFootbox() {
        if (this.getSkinParam().strictUmlStyle()) {
            return false;
        }
        String string = this.getSkinParam().getValue("footbox");
        if (string == null) {
            return this.showFootbox;
        }
        return !string.equalsIgnoreCase("hide");
    }

    public void setShowFootbox(boolean bl) {
        this.showFootbox = bl;
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.SEQUENCE;
    }

    public void boxStart(Display display, HtmlColor htmlColor) {
        if (this.participantEnglober != null) {
            throw new IllegalStateException();
        }
        this.participantEnglober = new ParticipantEnglober(display, htmlColor);
    }

    public void endBox() {
        if (this.participantEnglober == null) {
            throw new IllegalStateException();
        }
        this.participantEnglober = null;
    }

    public boolean isBoxPending() {
        return this.participantEnglober != null;
    }

    @Override
    public int getNbImages() {
        return this.getSequenceDiagramPngMaker(new FileFormatOption(FileFormat.PNG)).getNbPages();
    }

    public void removeHiddenParticipants() {
        for (Participant participant : new ArrayList<Participant>(this.participants.values())) {
            if (!this.isAlone(participant)) continue;
            this.remove(participant);
        }
    }

    private void remove(Participant participant) {
        boolean bl = this.participants.values().remove(participant);
        if (!bl) {
            throw new IllegalArgumentException();
        }
        this.participantEnglobers2.remove(participant);
    }

    private boolean isAlone(Participant participant) {
        for (Event event : this.events) {
            if (!event.dealWith(participant)) continue;
            return false;
        }
        return true;
    }

    public void putParticipantInLast(String string) {
        Participant participant = this.participants.get(string);
        if (participant == null) {
            throw new IllegalArgumentException(string);
        }
        this.participants.remove(string);
        this.participants.put(string, participant);
        this.participantEnglobers2.put(participant, this.participantEnglober);
    }

    public ParticipantEnglober getEnglober(Participant participant) {
        return this.participantEnglobers2.get(participant);
    }

    public final void setAutoactivate(boolean bl) {
        this.autoactivate = bl;
    }

    public final boolean isAutoactivate() {
        return this.autoactivate;
    }

    @Override
    public boolean hasUrl() {
        for (Participant object : this.participants.values()) {
            if (object.getUrl() == null) continue;
            return true;
        }
        for (Event event : this.events) {
            if (!event.hasUrl()) continue;
            return true;
        }
        return this.getLegend() != null && this.getLegend().hasUrl();
    }

    public void addReference(Reference reference) {
        this.events.add(reference);
    }

    @Override
    public boolean isOk() {
        return this.participants.size() != 0;
    }
}

