/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.asciiart.TextSkin;
import net.sourceforge.plantuml.asciiart.TextStringBounder;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSetInitializer;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.sequencediagram.graphic.Page;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class SequenceDiagramTxtMaker
implements FileMaker {
    private final SequenceDiagram diagram;
    private final DrawableSet drawableSet;
    private final Dimension2D fullDimension;
    private final StringBounder dummyStringBounder = new TextStringBounder();
    private final UGraphicTxt ug = new UGraphicTxt();
    private final FileFormat fileFormat;
    private final Skin skin;

    public SequenceDiagramTxtMaker(SequenceDiagram sequenceDiagram, FileFormat fileFormat) {
        this.fileFormat = fileFormat;
        this.diagram = sequenceDiagram;
        this.skin = new TextSkin(fileFormat);
        DrawableSetInitializer drawableSetInitializer = new DrawableSetInitializer(this.skin, sequenceDiagram.getSkinParam(), sequenceDiagram.isShowFootbox(), sequenceDiagram.getAutonewpage());
        for (Participant object : sequenceDiagram.participants().values()) {
            drawableSetInitializer.addParticipant(object, null);
        }
        for (Event event : sequenceDiagram.events()) {
            drawableSetInitializer.addEvent(event);
        }
        this.drawableSet = drawableSetInitializer.createDrawableSet(this.dummyStringBounder);
        this.fullDimension = this.drawableSet.getDimension();
        double d = this.drawableSet.getHeadHeight(this.dummyStringBounder);
        double d2 = this.drawableSet.getTailHeight(this.dummyStringBounder, this.diagram.isShowFootbox());
        double d3 = this.fullDimension.getHeight() - (this.diagram.isShowFootbox() ? d2 : 0.0) - d;
        Page page = new Page(d, 0.0, d3, d2, 0.0, null);
        this.drawableSet.drawU(this.ug, 0.0, this.fullDimension.getWidth(), page, this.diagram.isShowFootbox());
    }

    public ImageData createOne(OutputStream outputStream, int n, boolean bl) throws IOException {
        if (this.fileFormat == FileFormat.UTXT) {
            PrintStream printStream = new PrintStream(outputStream, true, "UTF-8");
            this.ug.getCharArea().print(printStream);
        } else {
            PrintStream printStream = new PrintStream(outputStream);
            this.ug.getCharArea().print(printStream);
        }
        return new ImageDataSimple(1, 1);
    }

    public int getNbPages() {
        return 1;
    }
}

