/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CommunicationTileSelf
implements Tile {
    private final LivingSpace livingSpace1;
    private final Message message;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final LivingSpaces livingSpaces;

    public Event getEvent() {
        return this.message;
    }

    public CommunicationTileSelf(LivingSpace livingSpace, Message message, Skin skin, ISkinParam iSkinParam, LivingSpaces livingSpaces) {
        this.livingSpace1 = livingSpace;
        this.livingSpaces = livingSpaces;
        this.message = message;
        this.skin = skin;
        this.skinParam = iSkinParam;
    }

    private Component getComponent(StringBounder stringBounder) {
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        arrowConfiguration = arrowConfiguration.self();
        Component component = this.skin.createComponent(ComponentType.ARROW, arrowConfiguration, this.skinParam, this.message.getLabel());
        return component;
    }

    public void updateStairs(StringBounder stringBounder, double d) {
        System.err.println("self=" + this.message.getLiveEvents() + " " + this.message.isActivate() + " " + this.message.isDeactivate());
        ArrowComponent arrowComponent = (ArrowComponent)this.getComponent(stringBounder);
        Dimension2D dimension2D = arrowComponent.getPreferredDimension(stringBounder);
        Point2D point2D = arrowComponent.getStartPoint(stringBounder, dimension2D);
        Point2D point2D2 = arrowComponent.getEndPoint(stringBounder, dimension2D);
        int n = this.livingSpace1.getLevelAt(this);
        System.err.println("CommunicationTileSelf level1=" + n + " y=" + d + " p1=" + point2D + " p2=" + point2D2 + " dim=" + dimension2D);
        if (this.message.isActivate()) {
            this.livingSpace1.addStep(d + point2D2.getY(), n);
        }
        if (this.message.isDeactivate()) {
            this.livingSpace1.addStep(d + point2D.getY(), n);
        }
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = this.getPoint1(stringBounder).getCurrentValue();
        int n = this.livingSpace1.getLevelAt(this);
        d += 8.0 * (double)n;
        Area area = new Area(dimension2D.getWidth(), dimension2D.getHeight());
        if (this.message.isActivate()) {
            area.setDeltaX1(-8.0);
        } else if (this.message.isDeactivate()) {
            area.setDeltaX1(8.0);
            d += 8.0 * (double)n;
        }
        uGraphic = uGraphic.apply(new UTranslate(d, 0.0));
        component.drawU(uGraphic, area, new SimpleContext2D(false));
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D.getHeight();
    }

    public void addConstraints(StringBounder stringBounder) {
        LivingSpace livingSpace = this.getNext();
        if (livingSpace != null) {
            livingSpace.getPosB().ensureBiggerThan(this.getMaxX(stringBounder));
        }
    }

    private LivingSpace getNext() {
        Iterator<LivingSpace> iterator = this.livingSpaces.values().iterator();
        while (iterator.hasNext()) {
            LivingSpace livingSpace = iterator.next();
            if (livingSpace != this.livingSpace1 || !iterator.hasNext()) continue;
            return iterator.next();
        }
        return null;
    }

    private Real getPoint1(StringBounder stringBounder) {
        return this.livingSpace1.getPosC(stringBounder);
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.getPoint1(stringBounder);
    }

    public Real getMaxX(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = dimension2D.getWidth();
        return this.livingSpace1.getPosC(stringBounder).addFixed(d);
    }
}

