/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UGraphicInterceptorUDrawable;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealMax;
import net.sourceforge.plantuml.real.RealMin;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.teoz.LiveBoxFinder;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TileBuilder;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainTile
implements Tile {
    private final RealMin min = new RealMin();
    private final RealMax max = new RealMax();
    private double height;
    private final List<Tile> tiles = new ArrayList<Tile>();

    public MainTile(SequenceDiagram sequenceDiagram, Skin skin, Real real, LivingSpaces livingSpaces, Real real2) {
        this.min.put(real2);
        this.max.put(real);
        ISkinParam iSkinParam = sequenceDiagram.getSkinParam();
        StringBounder stringBounder = TextBlockUtils.getDummyStringBounder();
        TileArguments tileArguments = new TileArguments(stringBounder, real, livingSpaces, skin, iSkinParam, real2);
        this.tiles.addAll(TileBuilder.buildSeveral(sequenceDiagram.events().iterator(), tileArguments, null));
        for (Tile tile : this.tiles) {
            this.height += tile.getPreferredHeight(stringBounder);
            this.min.put(tile.getMinX(stringBounder));
            this.max.put(tile.getMaxX(stringBounder));
        }
    }

    private void beforeDrawing(StringBounder stringBounder, Collection<LivingSpace> collection) {
        double d = 0.0;
        for (Tile tile : this.tiles) {
            System.err.println("tile=" + tile);
            d += tile.getPreferredHeight(stringBounder);
        }
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        LiveBoxFinder liveBoxFinder = new LiveBoxFinder(stringBounder);
        this.drawUInternal(liveBoxFinder);
        this.drawUInternal(new UGraphicInterceptorUDrawable(uGraphic));
    }

    private void drawUInternal(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = 0.0;
        for (Tile tile : this.tiles) {
            uGraphic.apply(new UTranslate(0.0, d)).draw(tile);
            d += tile.getPreferredHeight(stringBounder);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.height;
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        for (Tile tile : this.tiles) {
            tile.addConstraints(stringBounder);
        }
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        return this.min;
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        return this.max;
    }

    @Override
    public Event getEvent() {
        return null;
    }
}

