/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.skin.bluemodern.AbstractComponentBlueModernArrow;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentBlueModernArrow
extends AbstractComponentBlueModernArrow {
    public ComponentBlueModernArrow(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, boolean bl, UFont uFont, Display display, ArrowConfiguration arrowConfiguration, ISkinSimple iSkinSimple) {
        super(htmlColor, htmlColor2, htmlColor3, bl, uFont, display, arrowConfiguration, iSkinSimple);
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextHeight(stringBounder);
        uGraphic = uGraphic.apply(new UChangeColor(this.getForegroundColor()));
        uGraphic = uGraphic.apply(new UChangeBackColor(this.getForegroundColor()));
        int n2 = (int)dimension2D.getWidth();
        uGraphic = this.getArrowConfiguration().isDotted() ? this.stroke(uGraphic, 5.0, 2.0) : uGraphic.apply(new UStroke(2.0));
        uGraphic.apply(new UTranslate(2.0, n)).draw(new ULine(n2 - 4, 0.0));
        uGraphic = uGraphic.apply(new UStroke());
        int n3 = this.getDirection();
        UPolygon uPolygon = new UPolygon();
        if (this.getArrowConfiguration().isAsync()) {
            uGraphic = uGraphic.apply(new UStroke(1.5));
            if (n3 == 1) {
                if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                    uGraphic.apply(new UTranslate(n2 - this.getArrowDeltaX2(), n - this.getArrowDeltaY2())).draw(new ULine(this.getArrowDeltaX2(), this.getArrowDeltaY2()));
                }
                if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                    uGraphic.apply(new UTranslate(n2 - this.getArrowDeltaX2(), n + this.getArrowDeltaY2())).draw(new ULine(this.getArrowDeltaX2(), -this.getArrowDeltaY2()));
                }
            } else {
                if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                    uGraphic.apply(new UTranslate(this.getArrowDeltaX2(), n - this.getArrowDeltaY2())).draw(new ULine(-this.getArrowDeltaX2(), this.getArrowDeltaY2()));
                }
                if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                    uGraphic.apply(new UTranslate(this.getArrowDeltaX2(), n + this.getArrowDeltaY2())).draw(new ULine(-this.getArrowDeltaX2(), -this.getArrowDeltaY2()));
                }
            }
            uGraphic = uGraphic.apply(new UStroke());
        } else if (n3 == 1) {
            this.createPolygonNormal(n, n2, uPolygon);
        } else {
            this.createPolygonReverse(n, uPolygon);
        }
        uGraphic.draw(uPolygon);
        this.getTextBlock().drawU(uGraphic.apply(new UTranslate(this.getMarginX1(), 0.0)));
    }

    private void createPolygonReverse(int n, UPolygon uPolygon) {
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(this.getArrowDeltaX(), n);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), n);
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(this.getArrowDeltaX(), n + this.getArrowDeltaY());
        } else {
            uPolygon.addPoint(this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(this.getArrowDeltaX(), n + this.getArrowDeltaY());
        }
    }

    private void createPolygonNormal(int n, int n2, UPolygon uPolygon) {
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(n2, n);
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n);
            uPolygon.addPoint(n2, n);
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n + this.getArrowDeltaY());
        } else {
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(n2, n);
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n + this.getArrowDeltaY());
        }
    }

    protected int getDirection(Graphics2D graphics2D) {
        return this.getDirection();
    }

    protected int getDirection() {
        if (this.getArrowConfiguration().getArrowDirection() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            return 1;
        }
        if (this.getArrowConfiguration().getArrowDirection() == ArrowDirection.RIGHT_TO_LEFT_REVERSE) {
            return -1;
        }
        throw new IllegalStateException();
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + (double)this.getArrowDeltaY() + 2.0 * this.getPaddingY();
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder);
    }

    public Point2D getStartPoint(StringBounder stringBounder, Dimension2D dimension2D) {
        int n = (int)this.getTextHeight(stringBounder);
        if (this.getArrowConfiguration().getArrowDirection() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            return new Point2D.Double(this.getPaddingX(), (double)n + this.getPaddingY());
        }
        return new Point2D.Double(dimension2D.getWidth() + this.getPaddingX(), (double)n + this.getPaddingY());
    }

    public Point2D getEndPoint(StringBounder stringBounder, Dimension2D dimension2D) {
        int n = (int)this.getTextHeight(stringBounder);
        if (this.getArrowConfiguration().getArrowDirection() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            return new Point2D.Double(dimension2D.getWidth() + this.getPaddingX(), (double)n + this.getPaddingY());
        }
        return new Point2D.Double(this.getPaddingX(), (double)n + this.getPaddingY());
    }
}

